/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.endpoint;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.EndpointAnnotationParser;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.RouterAnnotationParser;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionParser;
import org.mule.api.registry.ObjectProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.config.AnnotationsParserFactory;
import org.mule.config.endpoint.ReplyAnnotationParser;
import org.mule.config.expression.BeanAnnotationParser;
import org.mule.config.expression.CustomEvaluatorAnnotationParser;
import org.mule.config.expression.ExpressionFilterAnnotationParser;
import org.mule.config.expression.FunctionAnnotationParser;
import org.mule.config.expression.GroovyAnnotationParser;
import org.mule.config.expression.MuleAnnotationParser;
import org.mule.config.expression.OgnlAnnotationParser;
import org.mule.config.expression.XPathAnnotationParser;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.processors.AnnotatedServiceObjectProcessor;
import org.mule.config.processors.DirectBindAnnotationProcessor;
import org.mule.config.processors.InjectAnnotationProcessor;
import org.mule.config.processors.NamedAnnotationProcessor;
import org.mule.config.routing.IdempotentRouterParser;
import org.mule.config.routing.SplitterRouterParser;
import org.mule.config.routing.WireTapRouterParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotationsParserFactory
implements AnnotationsParserFactory,
MuleContextAware {
    protected final transient Log logger = LogFactory.getLog(DefaultAnnotationsParserFactory.class);
    protected MuleContext muleContext;
    private List<EndpointAnnotationParser> endpointParsers = new ArrayList<EndpointAnnotationParser>();
    private List<ExpressionParser> expressionParsers = new ArrayList<ExpressionParser>();
    private List<RouterAnnotationParser> routerParsers = new ArrayList<RouterAnnotationParser>();
    private List<ObjectProcessor> processors = new ArrayList<ObjectProcessor>();

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.addDefaultParsers();
        this.addDefaultProcessors();
    }

    protected void addDefaultParsers() {
        this.registerEndpointParser(new ReplyAnnotationParser());
        this.registerRouterParser(new WireTapRouterParser());
        this.registerRouterParser(new IdempotentRouterParser());
        this.registerRouterParser(new ExpressionFilterAnnotationParser());
        this.registerRouterParser(new SplitterRouterParser());
        this.registerExpressionParser(new MuleAnnotationParser());
        this.registerExpressionParser(new CustomEvaluatorAnnotationParser());
        this.registerExpressionParser(new FunctionAnnotationParser());
        this.registerExpressionParser(new XPathAnnotationParser());
        this.registerExpressionParser(new BeanAnnotationParser());
        this.registerExpressionParser(new OgnlAnnotationParser());
        this.registerExpressionParser(new GroovyAnnotationParser());
    }

    protected void addDefaultProcessors() {
        this.registerObjectProcessor((ObjectProcessor)new AnnotatedServiceObjectProcessor());
        this.registerObjectProcessor((ObjectProcessor)new DirectBindAnnotationProcessor());
        this.registerObjectProcessor((ObjectProcessor)new InjectAnnotationProcessor());
        this.registerObjectProcessor((ObjectProcessor)new NamedAnnotationProcessor());
    }

    @Override
    public EndpointAnnotationParser getEndpointParser(Annotation annotation, Class aClass, Member member) {
        for (EndpointAnnotationParser parser : this.endpointParsers) {
            if (!parser.supports(annotation, aClass, member)) continue;
            return parser;
        }
        return null;
    }

    @Override
    public ExpressionParser getExpressionParser(Annotation annotation) {
        for (ExpressionParser parser : this.expressionParsers) {
            if (!parser.supports(annotation)) continue;
            return parser;
        }
        return null;
    }

    @Override
    public RouterAnnotationParser getRouterParser(Annotation annotation, Class aClass, Member member) {
        for (RouterAnnotationParser parser : this.routerParsers) {
            if (!parser.supports(annotation, aClass, member)) continue;
            return parser;
        }
        return null;
    }

    @Override
    public List<ObjectProcessor> getProcessors() {
        return this.processors;
    }

    protected void registerEndpointParser(EndpointAnnotationParser parser) {
        try {
            this.muleContext.getRegistry().registerObject("_" + parser.getClass().getSimpleName(), (Object)parser);
            this.endpointParsers.add(parser);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(CoreMessages.failedToCreate((String)parser.getClass().getName()), (Throwable)e);
        }
    }

    protected void registerExpressionParser(ExpressionParser parser) {
        try {
            this.muleContext.getRegistry().registerObject("_" + parser.getClass().getSimpleName(), (Object)parser);
            this.expressionParsers.add(parser);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(CoreMessages.failedToCreate((String)parser.getClass().getName()), (Throwable)e);
        }
    }

    protected void registerRouterParser(RouterAnnotationParser parser) {
        try {
            this.muleContext.getRegistry().registerObject("_" + parser.getClass().getSimpleName(), (Object)parser);
            this.routerParsers.add(parser);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(CoreMessages.failedToCreate((String)parser.getClass().getName()), (Throwable)e);
        }
    }

    protected void registerObjectProcessor(ObjectProcessor processor) {
        try {
            this.muleContext.getRegistry().registerObject("_" + processor.getClass().getSimpleName(), (Object)processor);
            this.processors.add(processor);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(CoreMessages.failedToCreate((String)processor.getClass().getName()), (Throwable)e);
        }
    }
}

