/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.msgsimple.source;

import java.util.HashMap;
import java.util.Map;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.InternalBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.source.MessageSource;

public final class MapMessageSource
implements MessageSource {
    private static final InternalBundle BUNDLE = InternalBundle.getInstance();
    private final Map<String, String> messages;

    private MapMessageSource(Builder builder) {
        this.messages = new HashMap<String, String>(builder.messages);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getKey(String key) {
        return this.messages.get(key);
    }

    public static final class Builder {
        private final Map<String, String> messages = new HashMap<String, String>();

        private Builder() {
        }

        public Builder put(String key, String message) {
            BUNDLE.checkNotNull(key, "cfg.map.nullKey");
            BUNDLE.checkNotNull(message, "cfg.map.nullValue");
            this.messages.put(key, message);
            return this;
        }

        public Builder putAll(Map<String, String> map) {
            BUNDLE.checkNotNull(map, "cfg.nullMap");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public MessageSource build() {
            return new MapMessageSource(this);
        }
    }
}

