/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.JsonNumEquivalence;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.processing.Processor;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class UniqueItemsValidator
extends AbstractKeywordValidator {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquivalence.getInstance();
    private final boolean uniqueItems;

    public UniqueItemsValidator(JsonNode digest) {
        super("uniqueItems");
        this.uniqueItems = digest.get(this.keyword).booleanValue();
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        if (!this.uniqueItems) {
            return;
        }
        HashSet set = Sets.newHashSet();
        JsonNode node = data.getInstance().getNode();
        for (JsonNode element : node) {
            if (set.add(EQUIVALENCE.wrap((Object)element))) continue;
            report.error(this.newMsg(data, bundle, "err.common.uniqueItems.duplicateElements"));
            return;
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.uniqueItems;
    }
}

