/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.keyword.validator;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.keyword.validator.KeywordValidatorFactory;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.messages.JsonSchemaConfigurationBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.load.MessageBundles;

public class ReflectionKeywordValidatorFactory
implements KeywordValidatorFactory {
    private static final String ERRMSG = "failed to build keyword validator";
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaConfigurationBundle.class);
    private final Constructor<? extends KeywordValidator> constructor;

    public ReflectionKeywordValidatorFactory(String name, Class<? extends KeywordValidator> clazz) {
        try {
            this.constructor = clazz.getConstructor(JsonNode.class);
        }
        catch (NoSuchMethodException ignored) {
            throw new IllegalArgumentException(BUNDLE.printf("noAppropriateConstructor", name, clazz.getCanonicalName()));
        }
    }

    @Override
    public KeywordValidator getKeywordValidator(JsonNode node) throws ProcessingException {
        try {
            return this.constructor.newInstance(node);
        }
        catch (InstantiationException e) {
            throw new ProcessingException(ERRMSG, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingException(ERRMSG, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ProcessingException(ERRMSG, (Throwable)e);
        }
    }
}

