/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.format.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.net.InetAddresses;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.NodeType;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.format.AbstractFormatAttribute;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.format.FormatAttribute;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class IPv6Attribute
extends AbstractFormatAttribute {
    private static final int IPV6_LENGTH = 16;
    private static final FormatAttribute INSTANCE = new IPv6Attribute();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private IPv6Attribute() {
        super("ipv6", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        String ipaddr = instance.textValue();
        if (InetAddresses.isInetAddress((String)ipaddr) && InetAddresses.forString((String)ipaddr).getAddress().length == 16) {
            return;
        }
        report.error(this.newMsg(data, bundle, "err.format.invalidIPV6Address").putArgument("value", ipaddr));
    }
}

