/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.UUID;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.NodeType;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.cfg.ValidationConfiguration;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.examples.Utils;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.format.AbstractFormatAttribute;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.format.FormatAttribute;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.library.DraftV4Library;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.library.Library;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.main.JsonSchema;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.main.JsonSchemaFactory;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.messages.JsonSchemaValidationBundle;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.load.MessageBundles;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.source.MapMessageSource;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.source.MessageSource;

public final class Example8 {
    public static void main(String ... args) throws IOException, ProcessingException {
        JsonNode customSchema = Utils.loadResource("/custom-fmt.json");
        JsonNode good = Utils.loadResource("/custom-fmt-good.json");
        JsonNode bad = Utils.loadResource("/custom-fmt-bad.json");
        Library library = DraftV4Library.get().thaw().addFormatAttribute("uuid", UUIDFormatAttribute.getInstance()).freeze();
        String key = "invalidUUID";
        String value = "input is not a valid UUID";
        MessageSource source = MapMessageSource.newBuilder().put("invalidUUID", "input is not a valid UUID").build();
        MessageBundle bundle = MessageBundles.getBundle(JsonSchemaValidationBundle.class).thaw().appendSource(source).freeze();
        ValidationConfiguration cfg = ValidationConfiguration.newBuilder().setDefaultLibrary("http://my.site/myschema#", library).setValidationMessages(bundle).freeze();
        JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setValidationConfiguration(cfg).freeze();
        JsonSchema schema = factory.getJsonSchema(customSchema);
        ProcessingReport report = schema.validate(good);
        System.out.println(report);
        report = schema.validate(bad);
        System.out.println(report);
    }

    private static final class UUIDFormatAttribute
    extends AbstractFormatAttribute {
        private static final FormatAttribute INSTANCE = new UUIDFormatAttribute();

        private UUIDFormatAttribute() {
            super("uuid", NodeType.STRING, new NodeType[0]);
        }

        public static FormatAttribute getInstance() {
            return INSTANCE;
        }

        @Override
        public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
            String value = data.getInstance().getNode().textValue();
            try {
                UUID.fromString(value);
            }
            catch (IllegalArgumentException ignored) {
                report.error(this.newMsg(data, bundle, "invalidUUID").put("input", value));
            }
        }
    }
}

