/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.processing;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.processing.Processor;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.processing.ProcessorSelectorPredicate;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.MessageProvider;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.load.MessageBundles;

@Immutable
public final class ProcessorSelector<IN extends MessageProvider, OUT extends MessageProvider> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    final Map<Predicate<IN>, Processor<IN, OUT>> choices;
    final Processor<IN, OUT> byDefault;

    public ProcessorSelector() {
        this.choices = Maps.newLinkedHashMap();
        this.byDefault = null;
    }

    private ProcessorSelector(Map<Predicate<IN>, Processor<IN, OUT>> choices, Processor<IN, OUT> byDefault) {
        this.choices = Maps.newLinkedHashMap(choices);
        this.byDefault = byDefault;
    }

    ProcessorSelector(ProcessorSelectorPredicate<IN, OUT> selector) {
        this(selector.choices, selector.byDefault);
    }

    public ProcessorSelectorPredicate<IN, OUT> when(Predicate<IN> predicate) {
        BUNDLE.checkNotNull(predicate, "processing.nullPredicate");
        return new ProcessorSelectorPredicate(this, predicate);
    }

    public ProcessorSelector<IN, OUT> otherwise(Processor<IN, OUT> byDefault) {
        BUNDLE.checkNotNull(byDefault, "processing.nullProcessor");
        return new ProcessorSelector<IN, OUT>(this.choices, byDefault);
    }

    public Processor<IN, OUT> getProcessor() {
        return new Chooser(this.choices, this.byDefault);
    }

    private static final class Chooser<X extends MessageProvider, Y extends MessageProvider>
    implements Processor<X, Y> {
        private final Map<Predicate<X>, Processor<X, Y>> map;
        private final Processor<X, Y> byDefault;

        private Chooser(Map<Predicate<X>, Processor<X, Y>> map, Processor<X, Y> byDefault) {
            this.map = ImmutableMap.copyOf(map);
            this.byDefault = byDefault;
        }

        @Override
        public Y process(ProcessingReport report, X input) throws ProcessingException {
            for (Map.Entry<Predicate<X>, Processor<X, Y>> entry : this.map.entrySet()) {
                Predicate<X> predicate = entry.getKey();
                Processor<X, Y> processor = entry.getValue();
                if (!predicate.apply(input)) continue;
                return processor.process(report, input);
            }
            if (this.byDefault != null) {
                return this.byDefault.process(report, input);
            }
            throw new ProcessingException(BUNDLE.getMessage("processing.noProcessor"));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("selector[").append(this.map.size()).append(" choices with ");
            if (this.byDefault == null) {
                sb.append("no ");
            }
            return sb.append("default]").toString();
        }
    }
}

