/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.hyperschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import java.util.Collection;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.NodeType;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class MediaSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String BINARY_ENCODING_FIELDNAME = "binaryEncoding";
    private static final String TYPE_FIELDNAME = "type";
    private static final ImmutableSet<String> BINARY_ENCODINGS = ImmutableSet.of((Object)"7bit", (Object)"8bit", (Object)"binary", (Object)"quoted-printable", (Object)"base64");
    private static final SyntaxChecker INSTANCE = new MediaSyntaxChecker();

    private MediaSyntaxChecker() {
        super("media", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        String value;
        NodeType type;
        JsonNode node = this.getNode(tree);
        JsonNode subNode = node.path(BINARY_ENCODING_FIELDNAME);
        if (!subNode.isMissingNode()) {
            type = NodeType.getNodeType(subNode);
            value = subNode.textValue();
            if (value == null) {
                report.error(this.newMsg(tree, bundle, "draftv4.media.binaryEncoding.incorrectType").put("expected", NodeType.STRING).putArgument("found", type));
            } else if (!BINARY_ENCODINGS.contains((Object)value.toLowerCase())) {
                report.error(this.newMsg(tree, bundle, "draftv4.media.binaryEncoding.invalid").putArgument("value", value).putArgument("valid", BINARY_ENCODINGS));
            }
        }
        if ((subNode = node.path(TYPE_FIELDNAME)).isMissingNode()) {
            return;
        }
        type = NodeType.getNodeType(subNode);
        if (type != NodeType.STRING) {
            report.error(this.newMsg(tree, bundle, "draftv4.media.type.incorrectType").put("expected", NodeType.STRING).putArgument("found", type));
            return;
        }
        value = subNode.textValue();
        try {
            MediaType.parse((String)value);
        }
        catch (IllegalArgumentException ignored) {
            report.error(this.newMsg(tree, bundle, "draftv4.media.type.notMediaType").putArgument("value", value));
        }
    }
}

