/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.build;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.processing.Processor;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.util.Dictionary;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.keyword.validator.KeywordValidatorFactory;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.library.Library;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.SchemaDigest;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.ValidatorList;

public final class ValidatorBuilder
implements Processor<SchemaDigest, ValidatorList> {
    private final Map<String, KeywordValidatorFactory> factories;

    public ValidatorBuilder(Library library) {
        this.factories = library.getValidators().entries();
    }

    public ValidatorBuilder(Dictionary<KeywordValidatorFactory> dict) {
        this.factories = dict.entries();
    }

    @Override
    public ValidatorList process(ProcessingReport report, SchemaDigest input) throws ProcessingException {
        TreeMap map = Maps.newTreeMap();
        for (Map.Entry<String, JsonNode> entry : input.getDigests().entrySet()) {
            String keyword = entry.getKey();
            JsonNode digest = entry.getValue();
            KeywordValidatorFactory factory = this.factories.get(keyword);
            KeywordValidator validator = factory.getKeywordValidator(digest);
            map.put(keyword, validator);
        }
        return new ValidatorList(input.getContext(), map.values());
    }

    public String toString() {
        return "validator builder";
    }
}

