/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.format.helpers;

import com.google.common.net.InetAddresses;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.NodeType;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.format.AbstractFormatAttribute;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class IPv4FormatAttribute
extends AbstractFormatAttribute {
    private static final int IPV4_LENGTH = 4;

    public IPv4FormatAttribute(String fmt) {
        super(fmt, NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String ipaddr = data.getInstance().getNode().textValue();
        if (InetAddresses.isInetAddress((String)ipaddr) && InetAddresses.forString((String)ipaddr).getAddress().length == 4) {
            return;
        }
        report.error(this.newMsg(data, bundle, "err.format.invalidIPv4Address").putArgument("value", ipaddr));
    }
}

