/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.processing;

import com.google.common.base.Equivalence;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.processing.ProcessingResult;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.processing.Processor;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ListProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.LogLevel;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.MessageProvider;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.util.equivalence.Equivalences;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.load.MessageBundles;

public final class CachingProcessor<IN extends MessageProvider, OUT extends MessageProvider>
implements Processor<IN, OUT> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final int DEFAULT_CACHE_SIZE = 512;
    private final Processor<IN, OUT> processor;
    private final Equivalence<IN> equivalence;
    private final LoadingCache<Equivalence.Wrapper<IN>, ProcessingResult<OUT>> cache;

    public CachingProcessor(Processor<IN, OUT> processor) {
        this(processor, Equivalences.equals());
    }

    public CachingProcessor(Processor<IN, OUT> processor, Equivalence<IN> equivalence) {
        this(processor, equivalence, 512);
    }

    public CachingProcessor(Processor<IN, OUT> processor, Equivalence<IN> equivalence, int cacheSize) {
        BUNDLE.checkNotNull(processor, "processing.nullProcessor");
        BUNDLE.checkNotNull(equivalence, "processing.nullEquivalence");
        BUNDLE.checkArgument(cacheSize >= -1, "processing.invalidCacheSize");
        this.processor = processor;
        this.equivalence = equivalence;
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (cacheSize != -1) {
            builder.maximumSize((long)cacheSize);
        }
        this.cache = builder.build(this.loader());
    }

    @Override
    public OUT process(ProcessingReport report, IN input) throws ProcessingException {
        ProcessingResult result;
        try {
            result = (ProcessingResult)this.cache.get((Object)this.equivalence.wrap(input));
        }
        catch (ExecutionException e) {
            throw (ProcessingException)e.getCause();
        }
        report.mergeWith(result.getReport());
        return (OUT)result.getResult();
    }

    private CacheLoader<Equivalence.Wrapper<IN>, ProcessingResult<OUT>> loader() {
        return new CacheLoader<Equivalence.Wrapper<IN>, ProcessingResult<OUT>>(){

            public ProcessingResult<OUT> load(Equivalence.Wrapper<IN> key) throws ProcessingException {
                MessageProvider input = (MessageProvider)key.get();
                ListProcessingReport report = new ListProcessingReport(LogLevel.DEBUG, LogLevel.NONE);
                return ProcessingResult.of(CachingProcessor.this.processor, report, input);
            }
        };
    }

    public String toString() {
        return "CACHED[" + this.processor + ']';
    }
}

