/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.load;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.load.Dereferencing;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.load.URIManager;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.load.uri.URITranslator;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.ref.JsonRef;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingMessage;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.load.MessageBundles;

@ThreadSafe
public final class SchemaLoader {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private final URIManager manager;
    private final URITranslator translator;
    private final LoadingCache<URI, JsonNode> cache;
    private final Dereferencing dereferencing;
    private final Map<URI, JsonNode> preloadedSchemas;

    public SchemaLoader(LoadingConfiguration cfg) {
        this.translator = new URITranslator(cfg.getTranslatorConfiguration());
        this.dereferencing = cfg.getDereferencing();
        this.manager = new URIManager(cfg);
        this.preloadedSchemas = ImmutableMap.copyOf(cfg.getPreloadedSchemas());
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (cfg.getCacheSize() != -1) {
            builder.maximumSize((long)cfg.getCacheSize());
        }
        this.cache = builder.build((CacheLoader)new CacheLoader<URI, JsonNode>(){

            @Nonnull
            public JsonNode load(@Nonnull URI key) throws ProcessingException {
                return SchemaLoader.this.manager.getContent(key);
            }
        });
    }

    public SchemaLoader() {
        this(LoadingConfiguration.byDefault());
    }

    public SchemaTree load(JsonNode schema) {
        BUNDLE.checkNotNull(schema, "loadingCfg.nullSchema");
        return this.dereferencing.newTree(schema);
    }

    public SchemaTree get(URI uri) throws ProcessingException {
        JsonRef ref = JsonRef.fromURI(this.translator.translate(uri));
        if (!ref.isAbsolute()) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.uriNotAbsolute")).putArgument("uri", ref));
        }
        URI realURI = ref.toURI();
        try {
            JsonNode node = this.preloadedSchemas.get(realURI);
            if (node == null) {
                node = (JsonNode)this.cache.get((Object)realURI);
            }
            return this.dereferencing.newTree(ref, node);
        }
        catch (ExecutionException e) {
            throw (ProcessingException)e.getCause();
        }
    }

    public String toString() {
        return this.cache.toString();
    }
}

