/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Equivalence;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.JacksonUtils;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.JsonNumEquivalence;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.NodeType;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;

public abstract class DependenciesSyntaxChecker
extends AbstractSyntaxChecker {
    protected static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquivalence.getInstance();
    protected final EnumSet<NodeType> dependencyTypes;

    protected DependenciesSyntaxChecker(NodeType ... depTypes) {
        super("dependencies", NodeType.OBJECT, new NodeType[0]);
        this.dependencyTypes = EnumSet.of(NodeType.OBJECT, depTypes);
    }

    @Override
    protected final void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        TreeMap map = Maps.newTreeMap();
        map.putAll(JacksonUtils.asMap(node));
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isObject()) {
                pointers.add(JsonPointer.of(this.keyword, key));
                continue;
            }
            this.checkDependency(report, bundle, (String)entry.getKey(), tree);
        }
    }

    protected abstract void checkDependency(ProcessingReport var1, MessageBundle var2, String var3, SchemaTree var4) throws ProcessingException;
}

