/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.common;

import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.helpers.SchemaMapSyntaxChecker;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.util.RegexECMA262Helper;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class PatternPropertiesSyntaxChecker
extends SchemaMapSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new PatternPropertiesSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private PatternPropertiesSyntaxChecker() {
        super("patternProperties");
    }

    @Override
    protected void extraChecks(ProcessingReport report, MessageBundle bundle, SchemaTree tree) throws ProcessingException {
        HashSet set = Sets.newHashSet((Iterator)this.getNode(tree).fieldNames());
        for (String s : Ordering.natural().sortedCopy((Iterable)set)) {
            if (RegexECMA262Helper.regexIsValid(s)) continue;
            report.error(this.newMsg(tree, bundle, "common.patternProperties.member.notRegex").putArgument("propertyName", s));
        }
    }
}

