/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.mule.module.json.api.JsonError;
import org.mule.module.json.internal.ValidatorCommonUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaParser {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaParser.class);

    private JsonSchemaParser() {
    }

    public static JsonNode getSchemaJsonNode(String schemaContent, String schemaLocation) {
        if (!ValidatorCommonUtils.isBlank(schemaContent)) {
            try {
                return objectMapper.readTree(schemaContent);
            }
            catch (JsonProcessingException e) {
                logger.error(e.getMessage());
                throw new ModuleException(String.format("Malformed Json Schema: %s", e.getMessage()), (ErrorTypeDefinition)JsonError.INVALID_INPUT_JSON);
            }
        }
        try {
            Preconditions.checkState((schemaLocation != null ? 1 : 0) != 0, (Object)"schemaLocation has not been provided");
            return objectMapper.readTree(new URL(ValidatorCommonUtils.resolveLocationIfNecessary(schemaLocation)));
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new ModuleException(String.format("Could not load JSON schema [%s]. %s", schemaLocation, e.getMessage()), (ErrorTypeDefinition)JsonError.SCHEMA_NOT_FOUND, (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new ModuleException(String.format("Malformed Json Schema: %s", e.getMessage()), (ErrorTypeDefinition)JsonError.INVALID_INPUT_JSON);
        }
    }
}

