/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.SpecVersionDetector;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.module.json.api.JsonError;
import org.mule.module.json.internal.JsonSchemaValidator;
import org.mule.module.json.internal.ValidatorCommonUtils;
import org.mule.module.json.internal.ValidatorKey;
import org.mule.module.json.internal.error.SchemaValidationException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class JsonSchemaValidatorNetworkntWrapper
extends JsonSchemaValidator {
    private static final Pattern INVALID_REFERENCE_MESSAGE_PATTERN = Pattern.compile("Reference.+cannot be resolved");
    private final JsonSchema jsonSchema;

    public JsonSchemaValidatorNetworkntWrapper(ValidatorKey key, JsonNode jsonSchemaNode) {
        super(key);
        this.jsonSchema = this.loadSchemaLibrary(jsonSchemaNode, super.getSchemaLocation(), super.getSchemaRedirects());
    }

    @Override
    public void validate(InputStream inputStream) {
        Set responseValidate;
        JsonNode jsonNode = super.asJsonNode(inputStream);
        try {
            responseValidate = this.jsonSchema.validate(jsonNode);
        }
        catch (JsonSchemaException e) {
            Matcher messageMatcher = INVALID_REFERENCE_MESSAGE_PATTERN.matcher(e.getMessage());
            if (messageMatcher.find()) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Invalid Schema References"), (Throwable)e);
            }
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Exception was found while trying to validate against json schema. Content was: " + jsonNode.toString())), (Throwable)e);
        }
        if (!responseValidate.isEmpty()) {
            throw new SchemaValidationException(responseValidate.toString());
        }
    }

    private JsonSchema loadSchemaLibrary(JsonNode jsonNode, String schemaLocation, Map<String, String> schemaRedirects) throws ModuleException {
        try {
            JsonSchemaFactory schemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersionDetector.detect((JsonNode)jsonNode));
            if (schemaLocation == null) {
                return schemaFactory.getSchema(jsonNode, this.getUriRedirectConfig(schemaRedirects));
            }
            return schemaFactory.getSchema(new URI(ValidatorCommonUtils.resolveLocationIfNecessary(schemaLocation)), this.getUriRedirectConfig(schemaRedirects));
        }
        catch (URISyntaxException e) {
            throw new ModuleException(String.format("Could not load JSON schema [%s]. %s", schemaLocation, e.getMessage()), (ErrorTypeDefinition)JsonError.SCHEMA_NOT_FOUND, (Throwable)e);
        }
    }

    private SchemaValidatorsConfig getUriRedirectConfig(Map<String, String> schemaRedirects) {
        SchemaValidatorsConfig schemaValidatorsConfig = new SchemaValidatorsConfig();
        if (!schemaRedirects.entrySet().isEmpty()) {
            HashMap<String, String> uriRedirects = new HashMap<String, String>();
            for (Map.Entry<String, String> redirect : schemaRedirects.entrySet()) {
                String key = ValidatorCommonUtils.resolveLocationIfNecessary(redirect.getKey());
                String value = ValidatorCommonUtils.resolveLocationIfNecessary(redirect.getValue());
                uriRedirects.put(key, value);
            }
            schemaValidatorsConfig.setUriMappings(uriRedirects);
        }
        return schemaValidatorsConfig;
    }
}

