/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.keyword.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Collection;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.JacksonUtils;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ExceptionProvider;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingMessage;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.exceptions.InvalidInstanceException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;

public abstract class AbstractKeywordValidator
implements KeywordValidator {
    private static final ExceptionProvider EXCEPTION_PROVIDER = new ExceptionProvider(){

        @Override
        public ProcessingException doException(ProcessingMessage message) {
            return new InvalidInstanceException(message);
        }
    };
    protected final String keyword;

    protected AbstractKeywordValidator(String keyword) {
        this.keyword = keyword;
    }

    protected final ProcessingMessage newMsg(FullData data) {
        return data.newMessage().put("domain", "validation").put("keyword", this.keyword).setExceptionProvider(EXCEPTION_PROVIDER);
    }

    protected final ProcessingMessage newMsg(FullData data, MessageBundle bundle, String key) {
        return data.newMessage().put("domain", "validation").put("keyword", this.keyword).setMessage(bundle.getMessage(key)).setExceptionProvider(EXCEPTION_PROVIDER);
    }

    protected static <T> JsonNode toArrayNode(Collection<T> collection) {
        ArrayNode node = JacksonUtils.nodeFactory().arrayNode();
        for (T element : collection) {
            node.add(element.toString());
        }
        return node;
    }

    public abstract String toString();
}

