/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.format.extra;

import java.util.regex.Pattern;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.NodeType;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.format.AbstractFormatAttribute;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.format.FormatAttribute;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class MacAddressFormatAttribute
extends AbstractFormatAttribute {
    private static final FormatAttribute instance = new MacAddressFormatAttribute();
    private static final Pattern MACADDR = Pattern.compile("[A-Za-z0-9]{2}(?::[A-Za-z0-9]{2}){5}");

    public static FormatAttribute getInstance() {
        return instance;
    }

    private MacAddressFormatAttribute() {
        super("mac", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        if (!MACADDR.matcher(input).matches()) {
            report.error(this.newMsg(data, bundle, "err.format.macAddr.invalid").putArgument("value", input));
        }
    }
}

