/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.util;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.mule.module.json.internal.shaded.com.github.fge.Thawed;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.util.Dictionary;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.load.MessageBundles;

@NotThreadSafe
public final class DictionaryBuilder<T>
implements Thawed<Dictionary<T>> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    final Map<String, T> entries = Maps.newHashMap();

    DictionaryBuilder() {
    }

    DictionaryBuilder(Dictionary<T> dict) {
        this.entries.putAll(dict.entries);
    }

    public DictionaryBuilder<T> addEntry(String key, T value) {
        BUNDLE.checkNotNull(key, "dictionary.nullKey");
        BUNDLE.checkNotNull(value, "dictionary.nullValue");
        this.entries.put(key, value);
        return this;
    }

    public DictionaryBuilder<T> addAll(Dictionary<T> other) {
        BUNDLE.checkNotNull(other, "dictionary.nullDict");
        this.entries.putAll(other.entries);
        return this;
    }

    public DictionaryBuilder<T> removeEntry(String key) {
        this.entries.remove(key);
        return this;
    }

    @Override
    public Dictionary<T> freeze() {
        return new Dictionary(this);
    }
}

