/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.keyword.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.NodeType;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.processing.RawProcessor;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingMessage;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import org.mule.module.json.internal.shaded.com.github.fge.jsonschema.core.util.Dictionary;
import org.mule.module.json.internal.shaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class SyntaxProcessor
extends RawProcessor<SchemaTree, SchemaTree> {
    private final MessageBundle bundle;
    private final Map<String, SyntaxChecker> checkers;

    public SyntaxProcessor(MessageBundle bundle, Dictionary<SyntaxChecker> dict) {
        super("schema", "schema");
        this.bundle = bundle;
        this.checkers = dict.entries();
    }

    @Override
    public SchemaTree rawProcess(ProcessingReport report, SchemaTree input) throws ProcessingException {
        this.validate(report, input);
        return input;
    }

    private void validate(ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = tree.getNode();
        NodeType type = NodeType.getNodeType(node);
        if (type != NodeType.OBJECT) {
            report.error(this.newMsg(tree, "core.notASchema").putArgument("found", type));
            return;
        }
        TreeMap map = Maps.newTreeMap();
        map.putAll(this.checkers);
        HashSet fields = Sets.newHashSet((Iterator)node.fieldNames());
        map.keySet().retainAll(fields);
        fields.removeAll(map.keySet());
        if (!fields.isEmpty()) {
            report.warn(this.newMsg(tree, "core.unknownKeywords").putArgument("ignored", Ordering.natural().sortedCopy((Iterable)fields)));
        }
        ArrayList pointers = Lists.newArrayList();
        for (SyntaxChecker checker : map.values()) {
            checker.checkSyntax(pointers, this.bundle, report, tree);
        }
        for (JsonPointer pointer : pointers) {
            this.validate(report, tree.append(pointer));
        }
    }

    private ProcessingMessage newMsg(SchemaTree tree, String key) {
        return new ProcessingMessage().put("schema", tree).put("domain", "syntax").setMessage(this.bundle.getMessage(key));
    }

    public String toString() {
        return "syntax checker";
    }
}

