/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal.shaded.com.github.fge.jackson.jsonpointer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.jsonpointer.JsonNodeResolver;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.jsonpointer.JsonPointerException;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.jsonpointer.ReferenceToken;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.jsonpointer.TokenResolver;
import org.mule.module.json.internal.shaded.com.github.fge.jackson.jsonpointer.TreePointer;

@Immutable
public final class JsonPointer
extends TreePointer<JsonNode> {
    private static final JsonPointer EMPTY = new JsonPointer(Collections.emptyList());

    public static JsonPointer empty() {
        return EMPTY;
    }

    public static JsonPointer of(Object first, Object ... other) {
        ArrayList<ReferenceToken> tokens = new ArrayList<ReferenceToken>();
        tokens.add(ReferenceToken.fromRaw(first.toString()));
        for (Object o : other) {
            tokens.add(ReferenceToken.fromRaw(o.toString()));
        }
        return new JsonPointer(JsonPointer.fromTokens(tokens));
    }

    public JsonPointer(String input) throws JsonPointerException {
        this(JsonPointer.fromTokens(JsonPointer.tokensFromInput(input)));
    }

    public JsonPointer(List<TokenResolver<JsonNode>> tokenResolvers) {
        super(MissingNode.getInstance(), tokenResolvers);
    }

    public JsonPointer append(String raw) {
        ReferenceToken refToken = ReferenceToken.fromRaw(raw);
        JsonNodeResolver resolver = new JsonNodeResolver(refToken);
        ArrayList<TokenResolver<JsonNode>> list = new ArrayList<TokenResolver<JsonNode>>();
        for (TokenResolver tokenResolver : this.tokenResolvers) {
            if (tokenResolver != null) {
                list.add(tokenResolver);
                continue;
            }
            throw new NullPointerException();
        }
        list.add(resolver);
        return new JsonPointer((List<TokenResolver<JsonNode>>)list);
    }

    public JsonPointer append(int index) {
        return this.append(Integer.toString(index));
    }

    public JsonPointer append(JsonPointer other) {
        BUNDLE.checkNotNull(other, "nullInput");
        ArrayList<TokenResolver<JsonNode>> list = new ArrayList<TokenResolver<JsonNode>>();
        for (TokenResolver tokenResolver : this.tokenResolvers) {
            if (tokenResolver != null) {
                list.add(tokenResolver);
                continue;
            }
            throw new NullPointerException();
        }
        list.addAll(other.tokenResolvers);
        return new JsonPointer((List<TokenResolver<JsonNode>>)list);
    }

    public JsonPointer parent() {
        int size = this.tokenResolvers.size();
        return size <= 1 ? EMPTY : new JsonPointer(this.tokenResolvers.subList(0, size - 1));
    }

    private static List<TokenResolver<JsonNode>> fromTokens(List<ReferenceToken> tokens) {
        ArrayList<TokenResolver<JsonNode>> list = new ArrayList<TokenResolver<JsonNode>>();
        for (ReferenceToken token : tokens) {
            list.add(new JsonNodeResolver(token));
        }
        return list;
    }
}

