/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.mule.module.json.api.JsonError;
import org.mule.module.json.api.JsonSchemaDereferencingMode;
import org.mule.module.json.internal.ValidatorCommonUtils;
import org.mule.module.json.internal.ValidatorKey;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonSchemaValidator {
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaValidator.class);
    private static final String VALIDATOR_FAIL_ON_TRAILING_TOKENS = "jsonSchemaValidator.FailOnTrailingTokens";
    private final ObjectMapper objectMapper;
    private static final String RESOURCE_PREFIX = "resource:/";
    private String schemaLocation;
    private JsonSchemaDereferencingMode dereferencing;
    protected static final String VALIDATION_FAILED_MESSAGE = "Json content is not compliant with schema.\n";
    protected static final String INVALID_SCHEMA_REFERENCE = "Invalid Schema References";
    protected static final String ERROR_TRYING_TO_VALIDATE = "Exception was found while trying to validate against json schema. Content was: ";
    protected static final String SCHEMA_NOT_FOUND_MSG = "Could not load JSON schema";
    private final Map<String, String> schemaRedirects = new HashMap<String, String>();

    protected JsonSchemaValidator(ValidatorKey key) {
        Preconditions.checkArgument((key.getDereferencingType() != null ? 1 : 0) != 0, (Object)"dereferencing cannot be null");
        this.schemaLocation = key.getSchemas();
        this.dereferencing = key.getDereferencingType();
        this.objectMapper = new ObjectMapper();
        if (!key.isAllowDuplicateKeys()) {
            this.objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});
        }
        if (key.isAllowArbitraryPrecision()) {
            this.objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        }
        if (Boolean.parseBoolean(System.getProperty(VALIDATOR_FAIL_ON_TRAILING_TOKENS, "false"))) {
            this.objectMapper.enable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS);
        }
        for (Map.Entry<String, String> redirect : key.getSchemaRedirects().entrySet()) {
            Preconditions.checkArgument((!ValidatorCommonUtils.isBlank(redirect.getKey()) ? 1 : 0) != 0, (Object)"from cannot be null or blank");
            Preconditions.checkArgument((!ValidatorCommonUtils.isBlank(redirect.getValue()) ? 1 : 0) != 0, (Object)"to cannot be null or blank");
            this.schemaRedirects.put(this.formatUri(redirect.getKey()), this.formatUri(redirect.getValue()));
        }
    }

    public abstract void validate(InputStream var1);

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public Map<String, String> getSchemaRedirects() {
        return this.schemaRedirects;
    }

    public JsonSchemaDereferencingMode getDereferencing() {
        return this.dereferencing;
    }

    public JsonNode asJsonNode(InputStream input) {
        try {
            return this.objectMapper.readTree(input);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new ModuleException("Invalid Input Content: " + e.getMessage(), (ErrorTypeDefinition)JsonError.INVALID_INPUT_JSON);
        }
    }

    private String formatUri(String location) {
        URI uri = URI.create(location);
        if (uri.getScheme() == null) {
            if (location.charAt(0) == '/') {
                location = location.substring(1);
            }
            location = RESOURCE_PREFIX + location;
        }
        return location;
    }
}

