/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.mule.module.json.api.JsonSchemaDereferencingMode;
import org.mule.module.json.api.SchemaRedirect;
import org.mule.module.json.internal.JsonAnyStaticTypeResolver;
import org.mule.module.json.internal.JsonSchemaValidator;
import org.mule.module.json.internal.error.SchemaValidatorErrorTypeProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.stereotype.Validator;
import org.mule.runtime.extension.api.exception.ModuleException;

public class ValidateJsonSchemaOperation
implements Startable,
Stoppable {
    private static final int MIN_IDLE_POOL_COUNT = 1;
    private static final int MAX_IDLE_POOL_COUNT = 32;
    @Inject
    TransformationService transformationService;
    private LoadingCache<ValidatorKey, GenericObjectPool<JsonSchemaValidator>> validatorPool;

    public void start() {
        this.validatorPool = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(notification -> ((GenericObjectPool)notification.getValue()).close()).build((CacheLoader)new CacheLoader<ValidatorKey, GenericObjectPool<JsonSchemaValidator>>(){

            public GenericObjectPool<JsonSchemaValidator> load(ValidatorKey key) throws Exception {
                return ValidateJsonSchemaOperation.this.createPool((BasePooledObjectFactory<JsonSchemaValidator>)ValidateJsonSchemaOperation.this.createPooledObjectFactory(key));
            }
        });
    }

    public void stop() {
        this.validatorPool.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Validator
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    @Throws(value={SchemaValidatorErrorTypeProvider.class})
    public void validateSchema(@Summary(value="The schema location") @Path(type=PathModel.Type.FILE, acceptedFileExtensions={"json"}) String schema, @TypeResolver(value=JsonAnyStaticTypeResolver.class) @Content Object content, @NullSafe @Optional Collection<SchemaRedirect> schemaRedirects, @Optional(defaultValue="CANONICAL") JsonSchemaDereferencingMode dereferencing, @Optional(defaultValue="true") @Placement(tab="Advanced") boolean allowDuplicateKeys, @Optional(defaultValue="false") @Placement(tab="Advanced") @Expression(value=ExpressionSupport.NOT_SUPPORTED) boolean allowArbitraryPrecision) {
        JsonSchemaValidator validator;
        InputStream contentInputStream = this.getContentToInputStream(content);
        GenericObjectPool pool = (GenericObjectPool)this.validatorPool.getUnchecked((Object)new ValidatorKey(schema, dereferencing, this.asMap(schemaRedirects), allowDuplicateKeys, allowArbitraryPrecision));
        try {
            validator = (JsonSchemaValidator)pool.borrowObject();
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not obtain schema validator"), (Throwable)e);
        }
        try {
            validator.validate(contentInputStream);
        }
        finally {
            pool.returnObject((Object)validator);
        }
    }

    private BasePooledObjectFactory<JsonSchemaValidator> createPooledObjectFactory(final ValidatorKey key) {
        return new BasePooledObjectFactory<JsonSchemaValidator>(){

            public JsonSchemaValidator create() throws Exception {
                return JsonSchemaValidator.builder().addSchemaRedirects(key.schemaRedirects).setDereferencing(key.dereferencingType).setSchemaLocation(key.schemas).allowDuplicateKeys(key.allowDuplicateKeys).allowArbitraryPrecision(key.allowArbitraryPrecision).build();
            }

            public void passivateObject(PooledObject<JsonSchemaValidator> p) throws Exception {
            }

            public PooledObject<JsonSchemaValidator> wrap(JsonSchemaValidator validator) {
                return new DefaultPooledObject((Object)validator);
            }
        };
    }

    private Map<String, String> asMap(Collection<SchemaRedirect> redirects) {
        return redirects.stream().collect(Collectors.toMap(SchemaRedirect::getFrom, SchemaRedirect::getTo));
    }

    private GenericObjectPool<JsonSchemaValidator> createPool(BasePooledObjectFactory<JsonSchemaValidator> factory) {
        return new GenericObjectPool(factory, this.defaultPoolConfig());
    }

    private GenericObjectPoolConfig defaultPoolConfig() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMinIdle(1);
        config.setMaxIdle(32);
        config.setMaxTotal(32);
        config.setBlockWhenExhausted(true);
        config.setTimeBetweenEvictionRunsMillis(TimeUnit.MINUTES.toMillis(5L));
        config.setTestOnBorrow(false);
        config.setTestOnReturn(false);
        config.setTestWhileIdle(false);
        config.setTestOnCreate(false);
        config.setJmxEnabled(false);
        return config;
    }

    private InputStream getContentToInputStream(Object content) {
        InputStream inputStream;
        if (content instanceof InputStream) {
            inputStream = (InputStream)content;
        } else if (content instanceof CursorStreamProvider) {
            inputStream = (InputStream)((CursorStreamProvider)content).openCursor();
        } else if (content instanceof String) {
            inputStream = new ByteArrayInputStream(((String)content).getBytes());
        } else if (content instanceof byte[]) {
            inputStream = new ByteArrayInputStream((byte[])content);
        } else {
            try {
                inputStream = (InputStream)this.transformationService.transform(content, DataType.fromObject((Object)content), DataType.INPUT_STREAM);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Unable to transform content of type [%s] value to a InputStream", content.getClass())), (Throwable)e);
            }
        }
        return inputStream;
    }

    class ValidatorKey {
        private String schemas;
        private JsonSchemaDereferencingMode dereferencingType;
        private Map<String, String> schemaRedirects;
        private final boolean allowDuplicateKeys;
        private final boolean allowArbitraryPrecision;

        public ValidatorKey(String schemas, JsonSchemaDereferencingMode dereferencingType, Map<String, String> schemaRedirects, boolean allowDuplicateKeys, boolean allowArbitraryPrecision) {
            this.schemas = schemas;
            this.dereferencingType = dereferencingType;
            this.schemaRedirects = schemaRedirects;
            this.allowDuplicateKeys = allowDuplicateKeys;
            this.allowArbitraryPrecision = allowArbitraryPrecision;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ValidatorKey) {
                ValidatorKey key = (ValidatorKey)obj;
                return Objects.equals(this.schemas, key.schemas) && this.dereferencingType == key.dereferencingType && Objects.equals(this.schemaRedirects, key.schemaRedirects);
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.schemas).append((Object)this.dereferencingType).append(this.schemaRedirects).toHashCode();
        }
    }
}

