/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.error;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.mule.module.apikit.error.RouterExceptionHandler;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.core.api.event.CoreEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleMessagingExceptionHandler
implements RouterExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleMessagingExceptionHandler.class);
    private final Constructor constructor = this.getMessagingExceptionConstructor(Thread.currentThread().getContextClassLoader());

    private Constructor getMessagingExceptionConstructor(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        try {
            Class<?> clazz = cl.loadClass("org.mule.runtime.core.internal.exception.MessagingException");
            return clazz.getConstructor(CoreEvent.class, Throwable.class);
        }
        catch (Exception e) {
            return this.getMessagingExceptionConstructor(cl.getParent());
        }
    }

    @Override
    public Exception handle(Event event, Exception exception) {
        try {
            if (this.constructor != null) {
                return (Exception)this.constructor.newInstance(event, exception.getCause());
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOGGER.error("Error while handling exception for main flow: " + e.getMessage());
        }
        LOGGER.warn("Cannot transform to MuleMessagingException. payload are not going to be propagated to the main flow");
        return exception;
    }
}

