/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.api.uri;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.mule.module.apikit.api.uri.URIPattern;
import org.mule.module.apikit.uri.Token;
import org.mule.module.apikit.uri.URIResolveResult;
import org.mule.module.apikit.uri.Variable;

public class URIResolver {
    private String _uri;

    public URIResolver(String uri) {
        this._uri = uri;
    }

    public String uri() {
        return this._uri;
    }

    public URIPattern find(Set<URIPattern> patterns) {
        return this.findFirst(patterns);
    }

    public URIPattern find(Set<URIPattern> patterns, MatchRule rule) {
        switch (rule) {
            case FIRST_MATCH: {
                return this.findFirst(patterns);
            }
            case BEST_MATCH: {
                return this.findBest(patterns);
            }
        }
        return null;
    }

    public Collection<URIPattern> findAll(Set<URIPattern> patterns) {
        ArrayList<URIPattern> matches = new ArrayList<URIPattern>();
        if (patterns == null || patterns.size() == 0) {
            return matches;
        }
        for (URIPattern p : patterns) {
            if (!p.match(this._uri)) continue;
            matches.add(p);
        }
        return matches;
    }

    public URIResolveResult resolve(URIPattern pattern) {
        URIResolveResult result = new URIResolveResult();
        Matcher mx = pattern.pattern().matcher(this._uri);
        boolean match = mx.matches();
        if (!match || mx.groupCount() != pattern.tokens().size()) {
            result.setStatus(URIResolveResult.Status.ERROR);
            return result;
        }
        List<Token> tokens = pattern.tokens();
        HashMap<Variable, Object> map = new HashMap<Variable, Object>();
        for (int i = 0; i < mx.groupCount(); ++i) {
            String s;
            Token mt = tokens.get(i);
            boolean wasSuccessful = mt.resolve(s = mx.group(i + 1), map);
            if (wasSuccessful) continue;
            result.setStatus(URIResolveResult.Status.ERROR);
            return result;
        }
        this.lookup(result, map);
        return result;
    }

    private void lookup(URIResolveResult result, Map<Variable, Object> map) {
        for (Map.Entry<Variable, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                result.put(entry.getKey().name(), value);
                continue;
            }
            result.setStatus(URIResolveResult.Status.ERROR);
            return;
        }
        result.setStatus(URIResolveResult.Status.RESOLVED);
    }

    private URIPattern findFirst(Set<URIPattern> patterns) {
        if (patterns == null || patterns.size() == 0) {
            return null;
        }
        for (URIPattern p : patterns) {
            if (!p.match(this._uri)) continue;
            return p;
        }
        return null;
    }

    private URIPattern findBest(Set<URIPattern> patterns) {
        if (patterns == null || patterns.size() == 0) {
            return null;
        }
        URIPattern best = null;
        for (URIPattern p : patterns) {
            if (!p.match(this._uri) || best != null && p.score() <= best.score()) continue;
            best = p;
        }
        return best;
    }

    public static enum MatchRule {
        FIRST_MATCH,
        BEST_MATCH;

    }
}

