/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.deserializing;

import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.mule.module.apikit.api.deserializing.ArrayHeaderDelimiter;

public class MimeTypeParser {
    protected static ParseResults parseMimeType(String mimeType) {
        String[] types;
        String[] parts = StringUtils.split((String)mimeType, (String)";");
        ParseResults results = new ParseResults();
        results.params = new HashMap<String, String>();
        for (int i = 1; i < parts.length; ++i) {
            String p = parts[i];
            String[] subParts = StringUtils.split((String)p, (char)'=');
            if (subParts.length != 2) continue;
            results.params.put(subParts[0].trim(), subParts[1].trim());
        }
        String fullType = parts[0].trim();
        if (fullType.equals("*")) {
            fullType = "*/*";
        }
        if ((types = StringUtils.split((String)fullType, (String)"/")).length > 0) {
            results.type = types[0].trim();
        }
        if (types.length > 1) {
            results.subType = types[1].trim();
        }
        return results;
    }

    protected static ParseResults parseMediaRange(String range) {
        ParseResults results = MimeTypeParser.parseMimeType(range);
        String q = results.params.get("q");
        float f = NumberUtils.toFloat((String)q, (float)1.0f);
        if (StringUtils.isBlank((String)q) || f < 0.0f || f > 1.0f) {
            results.params.put("q", "1");
        }
        return results;
    }

    protected static FitnessAndQuality fitnessAndQualityParsed(String mimeType, Collection<ParseResults> parsedRanges) {
        int bestFitness = -1;
        float bestFitQ = 0.0f;
        ParseResults target = MimeTypeParser.parseMediaRange(mimeType);
        if (target.type == null || target.subType == null) {
            return new FitnessAndQuality(bestFitness, bestFitQ);
        }
        for (ParseResults range : parsedRanges) {
            if (!target.type.equalsIgnoreCase(range.type) && (range.type == null || !range.type.equals("*")) && !target.type.equals("*") || !target.subType.equalsIgnoreCase(range.subType) && (range.subType == null || !range.subType.equals("*")) && !target.subType.equals("*")) continue;
            for (String k : target.params.keySet()) {
                int paramMatches = 0;
                if (!k.equals("q") && range.params.containsKey(k) && target.params.get(k).equals(range.params.get(k))) {
                    ++paramMatches;
                }
                int fitness = range.type.equalsIgnoreCase(target.type) ? 100 : 0;
                fitness += range.subType.equalsIgnoreCase(target.subType) ? 10 : 0;
                if ((fitness += paramMatches) <= bestFitness) continue;
                bestFitness = fitness;
                if (range.type.equals("*") && range.subType.equals("*")) {
                    bestFitQ = NumberUtils.toFloat((String)target.params.get("q"), (float)0.0f);
                    continue;
                }
                bestFitQ = NumberUtils.toFloat((String)range.params.get("q"), (float)0.0f);
            }
        }
        return new FitnessAndQuality(bestFitness, bestFitQ);
    }

    public static MediaType bestMatchForAcceptHeader(List<String> supportedRepresentations, String header) {
        LinkedList<ParseResults> parseResults = new LinkedList<ParseResults>();
        for (String r : StringUtils.split((String)header, (String)ArrayHeaderDelimiter.COMMA.getDelimiterValue())) {
            parseResults.add(MimeTypeParser.parseMediaRange(r));
        }
        LinkedList<FitnessAndQuality> weightedMatches = new LinkedList<FitnessAndQuality>();
        String quality = "1";
        for (String representation : supportedRepresentations) {
            FitnessAndQuality fitnessAndQuality = MimeTypeParser.fitnessAndQualityParsed(representation + ";q=" + quality, parseResults);
            fitnessAndQuality.mimeType = representation;
            weightedMatches.add(fitnessAndQuality);
            quality = "0.5";
        }
        Collections.sort(weightedMatches);
        FitnessAndQuality lastOne = (FitnessAndQuality)weightedMatches.get(weightedMatches.size() - 1);
        return NumberUtils.compare((float)lastOne.quality, (float)0.0f) != 0 ? MediaType.parse((String)lastOne.mimeType) : null;
    }

    protected static class FitnessAndQuality
    implements Comparable<FitnessAndQuality> {
        int fitness;
        float quality;
        String mimeType;

        public FitnessAndQuality(int fitness, float quality) {
            this.fitness = fitness;
            this.quality = quality;
        }

        @Override
        public int compareTo(FitnessAndQuality o) {
            if (this.fitness == o.fitness) {
                if (this.quality == o.quality) {
                    return 0;
                }
                return this.quality < o.quality ? -1 : 1;
            }
            return this.fitness < o.fitness ? -1 : 1;
        }
    }

    protected static class ParseResults {
        String type;
        String subType;
        Map<String, String> params;

        protected ParseResults() {
        }
    }
}

