/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.FormValidator;
import org.mule.module.apikit.validation.body.form.transformation.Multipart;
import org.mule.module.apikit.validation.body.form.transformation.MultipartBuilder;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;

public class MultipartFormValidator
implements FormValidator<TypedValue> {
    private final Map<String, List<Parameter>> formParameters;

    public MultipartFormValidator(Map<String, List<Parameter>> formParameters) {
        this.formParameters = formParameters;
    }

    @Override
    public TypedValue validate(TypedValue payload) throws BadRequestException {
        MultipartBuilder multipartBuilder = new MultipartBuilder(payload.getDataType().getMediaType().toString(), this.getBoundary(payload));
        Object value = payload.getValue();
        if (value instanceof CursorStreamProvider) {
            multipartBuilder.withCursorProvider((CursorStreamProvider)value);
        } else {
            multipartBuilder.withInputStream((InputStream)value);
        }
        for (Map.Entry<String, List<Parameter>> formParameter : this.formParameters.entrySet()) {
            Parameter parameter = formParameter.getValue().get(0);
            multipartBuilder.withExpectedParameter(formParameter.getKey(), parameter);
            if (parameter.getDefaultValue() == null) continue;
            multipartBuilder.withDefaultValue(formParameter.getKey(), parameter.getDefaultValue());
        }
        return this.getTypedValue(multipartBuilder.build());
    }

    private TypedValue getTypedValue(Multipart multipart) throws InvalidFormParameterException {
        Object is = multipart.content();
        MediaType mediaType = MediaType.parse((String)multipart.contentType());
        DataType dataType = DataType.builder((DataType)DataType.INPUT_STREAM).mediaType(mediaType).build();
        return new TypedValue(is, dataType, multipart.getLength());
    }

    private String getBoundary(TypedValue originalPayload) throws InvalidFormParameterException {
        String boundary = originalPayload.getDataType().getMediaType().getParameter("boundary");
        if (boundary == null) {
            throw new InvalidFormParameterException("Required boundary parameter not found");
        }
        return boundary;
    }
}

