/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidQueryParameterException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.validation.attributes.ValidatedQueryParams;
import org.mule.runtime.api.util.MultiMap;

public class QueryParameterValidator {
    public static ValidatedQueryParams validate(Map<String, Parameter> queryParameters, MultiMap<String, String> incomingQueryParams, String queryString, boolean queryParamsStrictValidation) throws InvalidQueryParameterException {
        if (queryParamsStrictValidation) {
            QueryParameterValidator.validateQueryParametersStrictly(queryParameters, incomingQueryParams);
        }
        return QueryParameterValidator.validateQueryParams(queryParameters, incomingQueryParams, queryString);
    }

    private static ValidatedQueryParams validateQueryParams(Map<String, Parameter> queryParameters, MultiMap<String, String> incomingQueryParams, String queryString) throws InvalidQueryParameterException {
        String queryStringWithDefaults = queryString;
        MultiMap<String, String> queryParamsCopy = AttributesHelper.copyImmutableMap(incomingQueryParams);
        for (Map.Entry<String, Parameter> paramDefinitionEntry : queryParameters.entrySet()) {
            Parameter parameterDefinition = paramDefinitionEntry.getValue();
            String paramKey = paramDefinitionEntry.getKey();
            List values = incomingQueryParams.getAll((Object)paramKey);
            if (values != null && !values.isEmpty()) {
                if (QueryParameterValidator.isSingleValueListOfNull(values) && parameterDefinition.isNullable()) {
                    QueryParameterValidator.validateQueryParam(queryParamsCopy, paramKey, parameterDefinition, (String)values.get(0));
                    continue;
                }
                if (parameterDefinition.isRepeat() || parameterDefinition.isArray()) {
                    QueryParameterValidator.validateQueryParamArray(paramKey, parameterDefinition, values);
                    continue;
                }
                if (values.size() > 1) {
                    throw new InvalidQueryParameterException("Query parameter " + paramKey + " is not repeatable");
                }
                QueryParameterValidator.validateQueryParam(queryParamsCopy, paramKey, parameterDefinition, (String)values.get(0));
                continue;
            }
            if (parameterDefinition.isRequired()) {
                throw new InvalidQueryParameterException("Required query parameter " + paramKey + " not specified");
            }
            if (paramDefinitionEntry.getValue().getDefaultValue() == null) continue;
            String queryParamDefaultValue = paramDefinitionEntry.getValue().getDefaultValue();
            queryStringWithDefaults = AttributesHelper.addQueryString(queryStringWithDefaults, paramKey, queryParamDefaultValue);
            queryParamsCopy.put((Object)paramKey, (Object)queryParamDefaultValue);
        }
        return new ValidatedQueryParams(queryParamsCopy, queryStringWithDefaults);
    }

    private static void validateQueryParametersStrictly(Map<String, Parameter> queryParameters, MultiMap<String, String> incomingQueryParams) throws InvalidQueryParameterException {
        Sets.SetView notDefinedQueryParameters = Sets.difference((Set)incomingQueryParams.keySet(), queryParameters.keySet());
        if (!notDefinedQueryParameters.isEmpty()) {
            throw new InvalidQueryParameterException(String.format("[%s] %s", Joiner.on((String)", ").join((Iterable)notDefinedQueryParameters), "parameters are not defined in API spec."));
        }
    }

    private static void validateQueryParamArray(String paramKey, Parameter expected, Collection<?> paramValues) throws InvalidQueryParameterException {
        if (!expected.validateArray(paramValues)) {
            String msg = String.format("Invalid value '%s' for query parameter %s. %s", paramValues.stream().map(String::valueOf).collect(Collectors.joining(", ")), paramKey, expected.messageFromValues(paramValues));
            throw new InvalidQueryParameterException(msg);
        }
    }

    private static void validateQueryParam(MultiMap<String, String> queryParams, String paramKey, Parameter parameterDefinition, String value) throws InvalidQueryParameterException {
        QueryParameterValidator.validate(paramKey, parameterDefinition, value);
        QueryParameterValidator.replaceNullStringValue(queryParams, paramKey, parameterDefinition, value);
    }

    private static void replaceNullStringValue(MultiMap<String, String> queryParams, String paramKey, Parameter parameterDefinition, String value) {
        if ("null".equals(value) && parameterDefinition.isNullable()) {
            queryParams.remove((Object)paramKey);
            queryParams.put((Object)paramKey, Arrays.asList(new String[]{null}));
        }
    }

    private static void validate(String paramKey, Parameter expected, String paramValue) throws InvalidQueryParameterException {
        if (!expected.validate(paramValue)) {
            String msg = String.format("Invalid value '%s' for query parameter %s. %s", paramValue, paramKey, expected.message(paramValue));
            throw new InvalidQueryParameterException(msg);
        }
    }

    private static boolean isSingleValueListOfNull(Collection<?> paramValues) {
        return paramValues.size() == 1 && paramValues.stream().allMatch(value -> value == null || "null".equals(value));
    }
}

