/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.apikit.model.ActionType;
import org.mule.module.apikit.api.exception.MethodNotAllowedException;

public class HttpMethodValidator {
    private static final Set<String> httpValidMethods = Arrays.asList(ActionType.values()).stream().map(value -> value.toString().toLowerCase()).collect(Collectors.toSet());

    public void validateHttpMethod(String requestMethod) throws MethodNotAllowedException {
        if (!httpValidMethods.contains(requestMethod)) {
            throw new MethodNotAllowedException(String.format("HTTP Method : %s is not allowed", requestMethod));
        }
    }
}

