/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.api.console;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.mule.apikit.ApiType;
import org.mule.apikit.model.ApiVendor;
import org.mule.module.apikit.ApikitErrorTypes;
import org.mule.module.apikit.api.config.ConsoleConfig;
import org.mule.module.apikit.api.console.ConsoleResource;
import org.mule.module.apikit.api.console.RamlResource;
import org.mule.module.apikit.api.console.Resource;
import org.mule.module.apikit.exception.NotFoundException;
import org.mule.module.apikit.helpers.APISpecModelHandlerImpl;
import org.mule.runtime.api.exception.ErrorTypeRepository;

public class ConsoleResources {
    private static final String ROOT_CONSOLE_PATH = "/";
    private static final String INDEX_RESOURCE_RELATIVE_PATH = "/index.html";
    private static final String RAML_LOCATION_PLACEHOLDER_KEY = "RAML_LOCATION_PLACEHOLDER";
    private final String CONSOLE_RESOURCES_BASE;
    private ConsoleConfig config;
    private String listenerPath;
    private String requestPath;
    private String queryString;
    private String method;
    private String acceptHeader;
    private String host;
    private ErrorTypeRepository errorTypeRepository;

    public ConsoleResources(ConsoleConfig config, String listenerPath, String requestPath, String queryString, String method, String acceptHeader, ErrorTypeRepository errorTypeRepository) {
        this.CONSOLE_RESOURCES_BASE = ApiType.AMF.equals((Object)config.getType()) ? "/console-resources-amf" : "/console-resources";
        this.config = config;
        this.listenerPath = listenerPath;
        this.requestPath = requestPath;
        this.queryString = queryString;
        this.method = method;
        this.acceptHeader = acceptHeader;
        this.errorTypeRepository = errorTypeRepository;
    }

    public ConsoleResources(ConsoleConfig config, String listenerPath, String requestPath, String queryString, String method, String acceptHeader, ErrorTypeRepository errorTypeRepository, String host) {
        this(config, listenerPath, requestPath, queryString, method, acceptHeader, errorTypeRepository);
        this.host = host;
    }

    public Resource getConsoleResource(String resourceRelativePath) {
        ConsoleResource consoleResource;
        String consoleResourcePath;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream resourceContent;
        block12: {
            Optional<String> apiSpecModel = this.getApiResourceIfRequested(resourceRelativePath);
            if (apiSpecModel.isPresent()) {
                return new RamlResource(apiSpecModel.get());
            }
            resourceContent = null;
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (resourceRelativePath.equals(ROOT_CONSOLE_PATH)) {
                consoleResourcePath = this.CONSOLE_RESOURCES_BASE + INDEX_RESOURCE_RELATIVE_PATH;
            } else {
                if (resourceRelativePath.endsWith(".map")) {
                    throw ApikitErrorTypes.throwErrorType(new NotFoundException(resourceRelativePath), this.errorTypeRepository);
                }
                consoleResourcePath = this.CONSOLE_RESOURCES_BASE + resourceRelativePath;
            }
            Path normalizedPath = Paths.get(consoleResourcePath, new String[0]).normalize();
            if (!normalizedPath.startsWith(this.CONSOLE_RESOURCES_BASE)) {
                throw ApikitErrorTypes.throwErrorType(new NotFoundException(resourceRelativePath), this.errorTypeRepository);
            }
            resourceContent = this.getClass().getResourceAsStream(consoleResourcePath);
            if (resourceContent != null) break block12;
            String ramlV2 = this.config.getRamlHandler().getRamlV2(resourceRelativePath);
            if (ramlV2 == null) {
                throw ApikitErrorTypes.throwErrorType(new NotFoundException(resourceRelativePath), this.errorTypeRepository);
            }
            RamlResource ramlResource = new RamlResource(ramlV2);
            IOUtils.closeQuietly((InputStream)resourceContent);
            IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
            return ramlResource;
        }
        try {
            if (consoleResourcePath.contains("index.html")) {
                resourceContent = this.updateIndexWithRamlLocation(resourceContent);
            }
            IOUtils.copyLarge((InputStream)resourceContent, (OutputStream)byteArrayOutputStream);
            consoleResource = new ConsoleResource(byteArrayOutputStream.toByteArray(), consoleResourcePath);
        }
        catch (IOException e) {
            try {
                throw ApikitErrorTypes.throwErrorType(new NotFoundException(resourceRelativePath), this.errorTypeRepository);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resourceContent);
                IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)resourceContent);
        IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        return consoleResource;
    }

    private InputStream updateIndexWithRamlLocation(InputStream inputStream) throws IOException {
        String ramlLocation = this.config.getRamlHandler().getApiVendor().equals((Object)ApiVendor.RAML_10) ? this.config.getRamlHandler().getRootRamlLocationForV2() : this.config.getRamlHandler().getRootRamlLocationForV1();
        String indexHtml = IOUtils.toString((InputStream)inputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        indexHtml = indexHtml.replaceFirst(RAML_LOCATION_PLACEHOLDER_KEY, ramlLocation);
        inputStream = new ByteArrayInputStream(indexHtml.getBytes());
        return inputStream;
    }

    public void isValidPath(String listenerPath) {
        if (listenerPath != null && !listenerPath.endsWith("/*")) {
            throw new IllegalStateException("Console path in listener must end with /*");
        }
    }

    private Optional<String> getApiResourceIfRequested(String resourceRelativePath) {
        APISpecModelHandlerImpl consoleApiModel = new APISpecModelHandlerImpl(this.config.getRamlHandler(), this.listenerPath, this.requestPath, this.queryString, this.method, this.acceptHeader, this.config.getType(), resourceRelativePath);
        return consoleApiModel.getModel(this.host);
    }
}

