/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.schema.v1.cache;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.google.common.cache.CacheLoader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.HashSet;
import org.mule.apikit.model.ApiSpecification;
import org.mule.module.apikit.api.exception.ApikitRuntimeException;
import org.mule.module.apikit.uri.URICoder;
import org.mule.module.apikit.validation.body.schema.v1.cache.SchemaCacheUtils;

public class JsonSchemaCacheLoader
extends CacheLoader<String, JsonSchema> {
    private static final String RESOURCE_PREFIX = "resource:/";
    private ApiSpecification api;

    public JsonSchemaCacheLoader(ApiSpecification api) {
        this.api = api;
    }

    public JsonSchema load(String schemaLocation) {
        Object pathOrSchema = SchemaCacheUtils.resolveJsonSchema(schemaLocation, this.api);
        if (pathOrSchema == null) {
            return null;
        }
        if (pathOrSchema instanceof String) {
            return this.parseSchema(this.resolveLocationIfNecessary(this.formatUri((String)pathOrSchema)));
        }
        return this.parseSchema((JsonNode)pathOrSchema);
    }

    private String formatUri(String location) {
        String encodedLocation = this.getEncodedPath(location);
        URI uri = URI.create(encodedLocation);
        if (uri.getScheme() == null) {
            if (location.charAt(0) == '/') {
                location = location.substring(1);
            }
            location = RESOURCE_PREFIX + location;
        }
        return location;
    }

    private String resolveLocationIfNecessary(String path) {
        String encodedUri = this.getEncodedPath(path);
        URI uri = URI.create(encodedUri);
        String scheme = uri.getScheme();
        if (scheme == null || "resource".equals(scheme)) {
            return this.openSchema(uri.getPath()).toString();
        }
        return path;
    }

    private String getEncodedPath(String path) {
        HashSet<Character> ignoredCharacters = new HashSet<Character>();
        ignoredCharacters.add(Character.valueOf('/'));
        ignoredCharacters.add(Character.valueOf(':'));
        return URICoder.encode(path, ignoredCharacters);
    }

    private URL openSchema(String path) {
        try {
            return Paths.get(path, new String[0]).toUri().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private JsonSchema parseSchema(JsonNode jsonNode) {
        try {
            return this.getSchemaFactory().getJsonSchema(jsonNode);
        }
        catch (ProcessingException e) {
            throw new ApikitRuntimeException(e);
        }
    }

    private JsonSchema parseSchema(String uri) {
        try {
            String decodedURI = URICoder.decode(uri);
            return this.getSchemaFactory().getJsonSchema(this.getEncodedPath(decodedURI));
        }
        catch (ProcessingException e) {
            throw new ApikitRuntimeException(e);
        }
    }

    private JsonSchemaFactory getSchemaFactory() {
        ValidationConfiguration validationCfg = ValidationConfiguration.newBuilder().setDefaultVersion(SchemaVersion.DRAFTV3).freeze();
        return JsonSchemaFactory.newBuilder().setLoadingConfiguration(LoadingConfiguration.byDefault()).setValidationConfiguration(validationCfg).freeze();
    }
}

