/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form.transformation;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.mule.apikit.model.parameter.FileProperties;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.transformation.MultipartFormDataParameter;
import org.mule.runtime.api.metadata.MediaType;

public class MultipartFormDataBinaryParameter
implements MultipartFormDataParameter {
    private final int length;
    private final MediaType mediaType;

    public MultipartFormDataBinaryParameter(int length, MediaType mediaType) {
        this.length = length;
        this.mediaType = mediaType;
    }

    @Override
    public void validate(Parameter parameter) throws InvalidFormParameterException {
        Optional fileProperties = parameter.getFileProperties();
        if (!fileProperties.isPresent()) {
            return;
        }
        FileProperties properties = (FileProperties)fileProperties.get();
        Set fileTypes = properties.getFileTypes();
        Integer minValue = properties.getMinLength();
        Integer maxValue = properties.getMaxLength();
        if (CollectionUtils.isNotEmpty((Collection)fileTypes) && !this.anyFileTypeAllowed(fileTypes) && !fileTypes.contains(this.mediaType.toString())) {
            throw new InvalidFormParameterException(String.format("Invalid content type: %s", this.mediaType.toString()));
        }
        if (minValue == 0 && maxValue == 0) {
            return;
        }
        if (this.length < minValue || this.length > maxValue) {
            throw new InvalidFormParameterException(String.format("Length must be between : %s and %s", properties.getMinLength(), properties.getMaxLength()));
        }
    }

    private boolean anyFileTypeAllowed(Set<String> fileTypes) {
        return fileTypes.size() == 1 && fileTypes.contains("*/*");
    }
}

