/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.apikit.model.QueryString;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidQueryStringException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.validation.attributes.ValidatedQueryParams;
import org.mule.module.apikit.validation.attributes.ValidationUtils;
import org.mule.runtime.api.util.MultiMap;

public class QueryStringValidator {
    public static ValidatedQueryParams validate(QueryString queryString, String rawQueryString, MultiMap<String, String> queryParams) throws InvalidQueryStringException {
        if (!QueryStringValidator.shouldProcessQueryString(queryString)) {
            return null;
        }
        Map facets = queryString.facets();
        Map<String, Parameter> facetsWithDefault = QueryStringValidator.getFacetsWithDefaultValue(facets);
        MultiMap<String, String> queryParamsCopy = AttributesHelper.copyImmutableMap(queryParams);
        StringBuilder queryStringYaml = QueryStringValidator.queryStringAsYaml(queryString, facets, facetsWithDefault, queryParamsCopy);
        QueryStringValidator.validateQueryString(queryStringYaml, queryString);
        return new ValidatedQueryParams(queryParamsCopy, QueryStringValidator.addDefaultValues(facetsWithDefault, queryParamsCopy, rawQueryString));
    }

    private static StringBuilder queryStringAsYaml(QueryString queryString, Map<String, Parameter> facets, Map<String, Parameter> facetsWithDefault, MultiMap<String, String> queryParamsCopy) {
        StringBuilder queryStringYaml = new StringBuilder();
        for (Object property : queryParamsCopy.keySet()) {
            Parameter facet = facets.get(property.toString());
            facetsWithDefault.remove(property.toString());
            List actualQueryParam = queryParamsCopy.getAll((Object)property.toString());
            queryStringYaml.append("\n").append(property).append(": ");
            if (actualQueryParam.size() > 1 || queryString.isFacetArray(property.toString())) {
                for (String value : actualQueryParam) {
                    queryStringYaml.append("\n  - ").append(ValidationUtils.escapeAndSurroundWithQuotesIfNeeded(facet, value));
                }
                queryStringYaml.append("\n");
                continue;
            }
            for (String value : actualQueryParam) {
                queryStringYaml.append(ValidationUtils.escapeAndSurroundWithQuotesIfNeeded(facet, value)).append("\n");
            }
        }
        return queryStringYaml;
    }

    private static String addDefaultValues(Map<String, Parameter> facetsWithDefault, MultiMap<String, String> queryParamsCopy, String rawQueryString) {
        for (Map.Entry<String, Parameter> entry : facetsWithDefault.entrySet()) {
            String defaultValue = entry.getValue().getDefaultValue();
            rawQueryString = AttributesHelper.addQueryString(rawQueryString, entry.getKey(), defaultValue);
            queryParamsCopy.put((Object)entry.getKey(), (Object)entry.getValue().getDefaultValue());
        }
        return rawQueryString;
    }

    private static void validateQueryString(StringBuilder queryStringYaml, QueryString queryString) throws InvalidQueryStringException {
        if (queryStringYaml.length() == 0) {
            queryStringYaml.append("{}");
        }
        if (!queryString.validate(queryStringYaml.toString())) {
            throw new InvalidQueryStringException("Invalid value for query string");
        }
    }

    private static boolean shouldProcessQueryString(QueryString queryString) {
        return queryString != null && !queryString.isArray() && !queryString.isScalar();
    }

    private static Map<String, Parameter> getFacetsWithDefaultValue(Map<String, Parameter> facets) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, Parameter> entry : facets.entrySet()) {
            if (entry.getValue().getDefaultValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

