/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.uri;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.module.apikit.uri.Matchable;
import org.mule.module.apikit.uri.TokenBase;
import org.mule.module.apikit.uri.URICoder;
import org.mule.module.apikit.uri.URITemplateSyntaxException;
import org.mule.module.apikit.uri.Variable;

public class TokenOperatorDX
extends TokenBase
implements Matchable {
    private Operator _operator;
    private List<Variable> _vars;
    private Pattern _pattern;

    public TokenOperatorDX(Operator op, List<Variable> vars) throws NullPointerException {
        super(TokenOperatorDX.toExpression(op, vars));
        if (op == null || vars == null) {
            throw new NullPointerException("The operator must have a value");
        }
        this._operator = op;
        this._vars = vars;
        this._pattern = op.pattern(vars);
    }

    public Operator operator() {
        return this._operator;
    }

    @Override
    public boolean isResolvable() {
        return this._operator.isResolvable(this._vars);
    }

    @Override
    public boolean resolve(String expanded, Map<Variable, Object> values) {
        if (this.isResolvable()) {
            this._operator.resolve(this._vars, expanded, values);
            return true;
        }
        return false;
    }

    @Override
    public boolean match(String part) {
        return this._pattern.matcher(part).matches();
    }

    @Override
    public Pattern pattern() {
        return this._pattern;
    }

    public static Operator toOperator(char c) {
        for (Operator o : Operator.values()) {
            if (o.character() != c) continue;
            return o;
        }
        return Operator.SUBSTITUTION;
    }

    public static TokenOperatorDX parse(String exp) throws URITemplateSyntaxException {
        String sexp = TokenOperatorDX.strip(exp);
        if (sexp.length() < 2) {
            throw new URITemplateSyntaxException(exp, "Cannot produce a valid token operator.");
        }
        char c = sexp.charAt(0);
        Operator operator = TokenOperatorDX.toOperator(c);
        List<Variable> variables = TokenOperatorDX.toVariables(operator == Operator.SUBSTITUTION ? sexp : sexp.substring(1));
        return new TokenOperatorDX(operator, variables);
    }

    private static String toExpression(Operator op, List<Variable> vars) {
        StringBuffer exp = new StringBuffer();
        exp.append('{');
        exp.append(op.character());
        boolean first = true;
        for (Variable v : vars) {
            if (!first) {
                exp.append(',');
            }
            exp.append(v.toString());
            first = false;
        }
        exp.append('}');
        return exp.toString();
    }

    public static enum Operator {
        QUERY_PARAMETER('?'){

            @Override
            boolean isResolvable(List<Variable> arg0) {
                return true;
            }

            @Override
            boolean resolve(List<Variable> vars, String value, Map<Variable, Object> values) {
                for (Variable var : vars) {
                    Pattern p = Pattern.compile("(?<=[&?]" + var.namePatternString() + "=)([^&#]*)");
                    Matcher m = p.matcher(value);
                    while (m.find()) {
                        values.put(var, m.group());
                    }
                }
                return true;
            }

            @Override
            Pattern pattern(List<Variable> vars) {
                StringBuffer pattern = new StringBuffer();
                pattern.append("\\?(");
                for (Variable var : vars) {
                    pattern.append('(');
                    pattern.append(var.namePatternString());
                    pattern.append("=[^&#]*)|");
                }
                pattern.append("&)*");
                return Pattern.compile(pattern.toString());
            }
        }
        ,
        PATH_PARAMETER(';'){

            @Override
            boolean isResolvable(List<Variable> vars) {
                return true;
            }

            @Override
            boolean resolve(List<Variable> vars, String value, Map<Variable, Object> values) {
                for (Variable var : vars) {
                    Pattern p = Pattern.compile("(?<=;" + var.namePatternString() + "=)([^;/?#]*)");
                    Matcher m = p.matcher(value);
                    while (m.find()) {
                        values.put(var, m.group());
                    }
                }
                return true;
            }

            @Override
            Pattern pattern(List<Variable> vars) {
                StringBuffer pattern = new StringBuffer();
                pattern.append("(?:");
                for (Variable var : vars) {
                    pattern.append("(?:;");
                    pattern.append(var.namePatternString());
                    pattern.append("=[^;/?#]*)|");
                }
                pattern.append(";)*");
                return Pattern.compile(pattern.toString());
            }
        }
        ,
        PATH_SEGMENT('/'){

            @Override
            boolean isResolvable(List<Variable> arg0) {
                return true;
            }

            @Override
            boolean resolve(List<Variable> vars, String value, Map<Variable, Object> values) {
                if (vars.size() != 1) {
                    throw new UnsupportedOperationException("Operator + cannot be resolved with multiple variables.");
                }
                values.put(vars.get(0), URICoder.decode(value));
                return true;
            }

            @Override
            Pattern pattern(List<Variable> vars) {
                return Pattern.compile("(?:/[^/?#]*)*");
            }
        }
        ,
        URI_INSERT('+'){

            @Override
            boolean resolve(List<Variable> vars, String value, Map<Variable, Object> values) {
                if (vars.size() != 1) {
                    throw new UnsupportedOperationException("Operator + cannot be resolved with multiple variables.");
                }
                values.put(vars.get(0), URICoder.decode(value));
                return true;
            }

            @Override
            boolean isResolvable(List<Variable> vars) {
                return vars.size() == 1;
            }

            @Override
            Pattern pattern(List<Variable> vars) {
                return Pattern.compile("[^?#]*");
            }
        }
        ,
        SUBSTITUTION(' '){

            @Override
            boolean resolve(List<Variable> vars, String value, Map<Variable, Object> values) {
                if (vars.size() != 1) {
                    throw new UnsupportedOperationException("Operator cannot be resolved with multiple variables.");
                }
                values.put(vars.get(0), URICoder.decode(value));
                return true;
            }

            @Override
            boolean isResolvable(List<Variable> vars) {
                return vars.size() == 1;
            }

            @Override
            Pattern pattern(List<Variable> vars) {
                return Pattern.compile("[^;/?#,&]*");
            }
        };

        private final char _c;

        private Operator(char c) {
            this._c = c;
        }

        public char character() {
            return this._c;
        }

        abstract boolean isResolvable(List<Variable> var1);

        abstract Pattern pattern(List<Variable> var1);

        abstract boolean resolve(List<Variable> var1, String var2, Map<Variable, Object> var3);
    }
}

