/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidQueryParameterException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.validation.attributes.ValidatedQueryParams;
import org.mule.runtime.api.util.MultiMap;

public class QueryParameterValidator {
    private final Action action;

    public QueryParameterValidator(Action action) {
        this.action = action;
    }

    public ValidatedQueryParams validate(MultiMap<String, String> queryParams, String queryString, boolean queryParamsStrictValidation) throws InvalidQueryParameterException {
        if (queryParamsStrictValidation) {
            this.validateQueryParametersStrictly(queryParams);
        }
        this.validateQueryParamsSize(queryParams);
        this.validateQueryParamsValues(queryParams);
        return this.addDefaultValues(queryParams, queryString);
    }

    private void validateQueryParamsSize(MultiMap<String, String> queryParams) throws InvalidQueryParameterException {
        for (Map.Entry queryParam : this.action.getQueryParameters().entrySet()) {
            String paramKey = (String)queryParam.getKey();
            Parameter parameterDefinition = (Parameter)queryParam.getValue();
            List values = queryParams.getAll((Object)paramKey);
            if (values.isEmpty() && parameterDefinition.isRequired()) {
                throw new InvalidQueryParameterException("Required query parameter " + paramKey + " not specified");
            }
            if (values.size() <= 1 || parameterDefinition.isRepeat() || parameterDefinition.isArray()) continue;
            throw new InvalidQueryParameterException("Query parameter " + paramKey + " is not repeatable");
        }
    }

    private void validateQueryParamsValues(MultiMap<String, String> queryParams) throws InvalidQueryParameterException {
        Map queryParamsDefinition = this.action.getQueryParameters();
        for (String paramKey : queryParams.keySet()) {
            Parameter parameterDefinition = (Parameter)queryParamsDefinition.get(paramKey);
            if (parameterDefinition == null) continue;
            List values = queryParams.getAll((Object)paramKey);
            if (parameterDefinition.isArray()) {
                this.validateQueryParamArray(paramKey, parameterDefinition, values);
                continue;
            }
            this.validateQueryParam(queryParams, paramKey, parameterDefinition, values);
        }
    }

    private ValidatedQueryParams addDefaultValues(MultiMap<String, String> queryParams, String queryString) {
        String queryStringWithDefaults = queryString;
        MultiMap<String, String> queryParamsWithDefaults = queryParams;
        for (Map.Entry queryParam : this.action.getQueryParameters().entrySet()) {
            String queryParamKey = (String)queryParam.getKey();
            List values = queryParams.getAll((Object)queryParamKey);
            if (!values.isEmpty() || ((Parameter)queryParam.getValue()).getDefaultValue() == null) continue;
            String queryParamDefaultValue = ((Parameter)queryParam.getValue()).getDefaultValue();
            queryStringWithDefaults = AttributesHelper.addQueryString(queryStringWithDefaults, queryParamKey, queryParamDefaultValue);
            queryParamsWithDefaults = AttributesHelper.copyImmutableMap(queryParamsWithDefaults);
            queryParamsWithDefaults.put((Object)queryParamKey, (Object)queryParamDefaultValue);
        }
        return new ValidatedQueryParams(queryParamsWithDefaults, queryStringWithDefaults);
    }

    private void validateQueryParametersStrictly(MultiMap<String, String> queryParams) throws InvalidQueryParameterException {
        Sets.SetView notDefinedQueryParameters = Sets.difference((Set)queryParams.keySet(), this.action.getQueryParameters().keySet());
        if (!notDefinedQueryParameters.isEmpty()) {
            throw new InvalidQueryParameterException(String.format("[%s] %s", Joiner.on((String)", ").join((Iterable)notDefinedQueryParameters), "parameters are not defined in RAML."));
        }
    }

    private void validateQueryParamArray(String paramKey, Parameter expected, Collection<?> paramValues) throws InvalidQueryParameterException {
        StringBuilder builder = new StringBuilder();
        paramValues.forEach(paramValue -> {
            String value = String.valueOf(paramValue);
            builder.append("- ");
            builder.append(expected.surroundWithQuotesIfNeeded(value));
            builder.append("\n");
        });
        this.validate(paramKey, expected, builder.toString());
    }

    private void validateQueryParam(MultiMap<String, String> queryParams, String paramKey, Parameter parameterDefinition, List<String> values) throws InvalidQueryParameterException {
        for (String value : values) {
            if ("null".equals(value) && this.isNullable(parameterDefinition)) {
                List copyWithoutNull = values.stream().filter(current -> !"null".equals(current)).collect(Collectors.toList());
                queryParams.remove((Object)paramKey);
                queryParams.put((Object)paramKey, copyWithoutNull);
                queryParams.put((Object)paramKey, (Object)null);
                continue;
            }
            this.validate(paramKey, parameterDefinition, parameterDefinition.surroundWithQuotesIfNeeded(value));
        }
    }

    private void validate(String paramKey, Parameter expected, String paramValue) throws InvalidQueryParameterException {
        if (!expected.validate(paramValue)) {
            String msg = String.format("Invalid value '%s' for query parameter %s. %s", paramValue, paramKey, expected.message(paramValue));
            throw new InvalidQueryParameterException(msg);
        }
    }

    private boolean isNullable(Parameter parameter) {
        return parameter.validate(null);
    }
}

