/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.Response;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.HeaderName;
import org.mule.module.apikit.api.exception.InvalidHeaderException;
import org.mule.module.apikit.exception.NotAcceptableException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.validation.attributes.MimeTypeParser;
import org.mule.runtime.api.util.MultiMap;

public class HeadersValidator {
    private final Action action;
    private final List<String> mimeTypes;

    public HeadersValidator(Action action) {
        this.action = action;
        this.mimeTypes = this.getResponseMimeTypes(action);
    }

    public MultiMap<String, String> validateAndAddDefaults(MultiMap<String, String> incomingHeaders, boolean headersStrictValidation) throws InvalidHeaderException, NotAcceptableException {
        MultiMap<String, String> headersWithDefaults = this.analyseRequestHeaders(incomingHeaders, headersStrictValidation);
        this.analyseAcceptHeader(headersWithDefaults);
        return headersWithDefaults;
    }

    private MultiMap<String, String> analyseRequestHeaders(MultiMap<String, String> incomingHeaders, boolean headersStrictValidation) throws InvalidHeaderException {
        if (headersStrictValidation) {
            this.validateHeadersStrictly((Map<String, String>)incomingHeaders);
        }
        MultiMap<String, String> copyIncomingHeaders = incomingHeaders;
        for (Map.Entry entry : this.action.getHeaders().entrySet()) {
            String ramlHeader = (String)entry.getKey();
            Parameter ramlType = (Parameter)entry.getValue();
            if (ramlHeader.contains("{?}")) {
                String regex = ramlHeader.replace("{?}", ".*");
                for (String incomingHeader : copyIncomingHeaders.keySet()) {
                    if (!incomingHeader.matches(regex)) continue;
                    this.validateHeader(copyIncomingHeaders.getAll((Object)incomingHeader), ramlHeader, ramlType);
                }
                continue;
            }
            List<String> values = AttributesHelper.getParamsIgnoreCase(copyIncomingHeaders, ramlHeader);
            if (values.isEmpty() && ramlType.isRequired()) {
                throw new InvalidHeaderException("\"Required header '" + ramlHeader + "' not specified\"");
            }
            if (values.isEmpty() && ramlType.getDefaultValue() != null) {
                copyIncomingHeaders = AttributesHelper.copyImmutableMap(copyIncomingHeaders, ramlHeader, ramlType.getDefaultValue());
            }
            this.validateHeader(values, ramlHeader, ramlType);
        }
        return copyIncomingHeaders;
    }

    private void validateHeadersStrictly(Map<String, String> headers) throws InvalidHeaderException {
        Set standardHeaders;
        Set ramlHeaders = this.action.getHeaders().keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
        Set templateHeaders = ramlHeaders.stream().filter(header -> header.contains("{?}")).map(header -> header.replace("{?}", ".*")).collect(Collectors.toSet());
        Set unmatchedHeaders = headers.keySet().stream().filter(header -> templateHeaders.stream().noneMatch(header::matches)).collect(Collectors.toSet());
        Sets.SetView undefinedHeaders = Sets.difference(unmatchedHeaders, (Set)Sets.union(ramlHeaders, standardHeaders = Arrays.stream(HeaderName.values()).map(header -> header.getName().toLowerCase()).collect(Collectors.toSet())));
        if (!undefinedHeaders.isEmpty()) {
            throw new InvalidHeaderException(String.format("\"[%s] %s\"", Joiner.on((String)", ").join((Iterable)undefinedHeaders), "headers are not defined in RAML strict headers validation property is true."));
        }
    }

    private void validateHeader(List<String> values, String name, Parameter type) throws InvalidHeaderException {
        if (values.isEmpty()) {
            return;
        }
        if (values.size() > 1 && !type.isArray() && !type.isRepeat()) {
            throw new InvalidHeaderException("Header " + name + " is not repeatable");
        }
        if (type.isArray()) {
            this.validateType(name, values, type);
        } else {
            this.validateType(name, values.get(0), type);
        }
    }

    private void validateType(String name, List<String> values, Parameter type) throws InvalidHeaderException {
        StringBuilder yamlValue = new StringBuilder();
        for (String value : values) {
            yamlValue.append("- ").append(value).append("\n");
        }
        this.validateType(name, yamlValue.toString(), type);
    }

    private void validateType(String name, String value, Parameter type) throws InvalidHeaderException {
        if (!type.validate(value)) {
            throw new InvalidHeaderException(String.format("\"Invalid value '%s' for header '%s'\"", value, name));
        }
    }

    private void analyseAcceptHeader(MultiMap<String, String> incomingHeaders) throws NotAcceptableException {
        if (this.action == null || this.action.getResponses() == null || this.mimeTypes.isEmpty()) {
            return;
        }
        MediaType bestMatch = MimeTypeParser.bestMatch(this.mimeTypes, AttributesHelper.getAcceptedResponseMediaTypes(incomingHeaders));
        if (bestMatch == null) {
            throw new NotAcceptableException();
        }
    }

    private List<String> getResponseMimeTypes(Action action) {
        String status = this.getSuccessStatus(action);
        Response response = (Response)action.getResponses().get(status);
        if (response != null && response.hasBody()) {
            return new ArrayList<String>(response.getBody().keySet());
        }
        return new ArrayList<String>();
    }

    protected String getSuccessStatus(Action action) {
        for (String status : action.getResponses().keySet()) {
            if ("default".equalsIgnoreCase(status)) {
                return "200";
            }
            int code = Integer.parseInt(status);
            if (code < 200 || code >= 300) continue;
            return status;
        }
        return "200";
    }
}

