/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.FormValidator;
import org.mule.module.apikit.validation.body.form.transformation.DataWeaveTransformer;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlencodedFormV2Validator
implements FormValidator<TypedValue> {
    protected static final Logger logger = LoggerFactory.getLogger(UrlencodedFormV2Validator.class);
    Map<String, List<Parameter>> formParameters;
    MimeType actionMimeType;
    DataWeaveTransformer dataWeaveTransformer;

    public UrlencodedFormV2Validator(MimeType actionMimeType, ExpressionManager expressionManager) {
        this.formParameters = actionMimeType.getFormParameters();
        this.actionMimeType = actionMimeType;
        this.dataWeaveTransformer = new DataWeaveTransformer(expressionManager);
    }

    @Override
    public TypedValue validate(TypedValue originalPayload) throws BadRequestException {
        MultiMap<String, String> requestMap = this.dataWeaveTransformer.getMultiMapFromPayload(originalPayload);
        this.validateAndAddDefaults(requestMap);
        return this.dataWeaveTransformer.getXFormUrlEncodedStream(requestMap, originalPayload.getDataType());
    }

    private void validateAndAddDefaults(MultiMap<String, String> requestMap) throws InvalidFormParameterException {
        Map formParameters = this.actionMimeType.getFormParameters();
        Set expectedKeys = formParameters.keySet();
        for (String expectedKey : expectedKeys) {
            Parameter parameter = (Parameter)((List)formParameters.get(expectedKey)).get(0);
            List values = requestMap.getAll((Object)expectedKey);
            if (values.isEmpty()) {
                String defaultValue = parameter.getDefaultValue();
                if (defaultValue != null) {
                    requestMap.put((Object)expectedKey, (Object)defaultValue);
                    continue;
                }
                if (!parameter.isRequired()) continue;
                throw new InvalidFormParameterException("Required parameter " + expectedKey + " not specified");
            }
            if (parameter.isRepeat() || parameter.isArray()) {
                this.validateAsArray(expectedKey, parameter, values);
                continue;
            }
            if (values.size() > 1) {
                throw new InvalidFormParameterException("Parameter '" + expectedKey + "' is not repeatable");
            }
            this.validate(expectedKey, parameter, (String)values.get(0));
        }
    }

    private void validate(String expectedKey, Parameter parameter, String value) throws InvalidFormParameterException {
        if (!parameter.validate(value)) {
            throw new InvalidFormParameterException("\"Invalid value '" + value + "' for parameter\"" + expectedKey);
        }
    }

    private void validateAsArray(String expectedKey, Parameter parameter, List<String> values) throws InvalidFormParameterException {
        String valueToValidate = values.stream().map(v -> "- " + v).collect(Collectors.joining("\n"));
        if (!parameter.validate(valueToValidate) && !parameter.validate(values.stream().map(v -> "- '" + v + "'").collect(Collectors.joining("\n")))) {
            throw new InvalidFormParameterException("\"Invalid value '" + valueToValidate + "' for parameter\"" + expectedKey);
        }
    }
}

