/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import java.util.Map;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.api.exception.InvalidUriParameterException;
import org.mule.module.apikit.api.uri.ResolvedVariables;
import org.mule.runtime.api.util.MultiMap;

public class UriParametersValidator {
    MultiMap<String, String> uriParams;
    Action action;
    ResolvedVariables resolvedVariables;

    public UriParametersValidator(Action action, ResolvedVariables resolvedVariables) {
        this.action = action;
        this.resolvedVariables = resolvedVariables;
    }

    public void validate(Map<String, String> uriParams) throws InvalidUriParameterException {
        this.uriParams = new MultiMap(uriParams);
        for (Map.Entry entry : this.action.getResolvedUriParameters().entrySet()) {
            String value = (String)this.resolvedVariables.get((String)entry.getKey());
            Parameter uriParameter = (Parameter)entry.getValue();
            if (uriParameter.validate(value)) continue;
            String msg = String.format("\"Invalid value '%s' for uri parameter %s. %s\"", value, entry.getKey(), uriParameter.message(value));
            throw new InvalidUriParameterException(msg);
        }
    }
}

