/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.MimeType;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.api.validation.ApiKitJsonSchema;
import org.mule.module.apikit.api.validation.ValidBody;
import org.mule.module.apikit.exception.UnsupportedMediaTypeException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.helpers.PayloadHelper;
import org.mule.module.apikit.validation.body.form.FormValidator;
import org.mule.module.apikit.validation.body.form.FormValidatorFactory;
import org.mule.module.apikit.validation.body.schema.IRestSchemaValidatorStrategy;
import org.mule.module.apikit.validation.body.schema.v1.RestJsonSchemaValidator;
import org.mule.module.apikit.validation.body.schema.v1.RestXmlSchemaValidator;
import org.mule.module.apikit.validation.body.schema.v1.cache.SchemaCacheUtils;
import org.mule.module.apikit.validation.body.schema.v2.RestSchemaV2Validator;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.metadata.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyValidator {
    protected static final Logger logger = LoggerFactory.getLogger(BodyValidator.class);

    public static ValidBody validate(Action action, HttpRequestAttributes attributes, Object payload, ValidationConfig config, String charset) throws BadRequestException, UnsupportedMediaTypeException {
        return BodyValidator.validate(action, attributes, payload, config, charset, null);
    }

    public static ValidBody validate(Action action, HttpRequestAttributes attributes, Object payload, ValidationConfig config, String charset, ErrorTypeRepository errorTypeRepository) throws BadRequestException, UnsupportedMediaTypeException {
        ValidBody validBody = new ValidBody(payload);
        if (action == null || !action.hasBody()) {
            logger.debug("=== no body types defined: accepting any request content-type");
            return validBody;
        }
        String requestMimeTypeName = AttributesHelper.getMediaType(attributes);
        Map.Entry foundMimeType = action.getBody().entrySet().stream().peek(entry -> {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("comparing request media type %s with expected %s\n", requestMimeTypeName, entry.getKey()));
            }
        }).filter(entry -> AttributesHelper.getMediaType((String)entry.getKey()).equals(requestMimeTypeName)).findFirst().orElseThrow(UnsupportedMediaTypeException::new);
        MimeType mimeType = (MimeType)foundMimeType.getValue();
        if (requestMimeTypeName.contains("json") || requestMimeTypeName.contains("xml")) {
            validBody = BodyValidator.validateAsString(config, mimeType, action, requestMimeTypeName, payload, charset, errorTypeRepository);
        } else if (requestMimeTypeName.contains("multipart/") || requestMimeTypeName.contains("application/x-www-form-urlencoded")) {
            validBody = BodyValidator.validateAsMultiPart(config, mimeType, requestMimeTypeName, payload);
        }
        return validBody;
    }

    private static ValidBody validateAsString(ValidationConfig config, MimeType mimeType, Action action, String requestMimeTypeName, Object payload, String charset, ErrorTypeRepository errorTypeRepository) throws BadRequestException {
        IRestSchemaValidatorStrategy validator = null;
        if (config.isParserV2()) {
            validator = new RestSchemaV2Validator(mimeType);
        } else {
            String schemaPath = SchemaCacheUtils.getSchemaCacheKey(action, requestMimeTypeName);
            try {
                if (requestMimeTypeName.contains("json")) {
                    ApiKitJsonSchema schema = config.getJsonSchema(schemaPath);
                    validator = new RestJsonSchemaValidator(schema != null ? schema.getSchema() : null);
                } else if (requestMimeTypeName.contains("xml")) {
                    validator = new RestXmlSchemaValidator(config.getXmlSchema(schemaPath), errorTypeRepository);
                }
            }
            catch (ExecutionException e) {
                throw new BadRequestException(e);
            }
        }
        if (validator == null) {
            throw new BadRequestException(String.format("Unexpected Mime Type %s", requestMimeTypeName));
        }
        ValidBody validBody = new ValidBody(payload);
        validator.validate(PayloadHelper.getPayloadAsString(validBody.getPayload(), charset));
        return validBody;
    }

    private static ValidBody validateAsMultiPart(ValidationConfig config, MimeType mimeType, String requestMimeTypeName, Object payload) throws BadRequestException {
        ValidBody validBody = new ValidBody(payload);
        if (mimeType.getFormParameters() != null) {
            TypedValue payloadAsTypedValue = validBody.getPayloadAsTypedValue();
            FormValidator formValidator = new FormValidatorFactory(mimeType, config.getExpressionManager()).createValidator(requestMimeTypeName, config.isParserV2());
            validBody.setFormParameters(formValidator.validate(payloadAsTypedValue));
        }
        return validBody;
    }
}

