/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import org.mule.apikit.model.Action;
import org.mule.apikit.model.Resource;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.api.uri.ResolvedVariables;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.validation.attributes.HeadersValidator;
import org.mule.module.apikit.validation.attributes.QueryParameterValidator;
import org.mule.module.apikit.validation.attributes.QueryStringValidator;
import org.mule.module.apikit.validation.attributes.UriParametersValidator;
import org.mule.runtime.api.util.MultiMap;

public class AttributesValidator {
    public static HttpRequestAttributes validateAndAddDefaults(HttpRequestAttributes attributes, Resource resource, ResolvedVariables resolvedVariables, ValidationConfig config) throws MuleRestException {
        Action action = resource.getAction(attributes.getMethod().toLowerCase());
        UriParametersValidator uriParametersValidator = new UriParametersValidator(action, resolvedVariables);
        uriParametersValidator.validate(attributes.getUriParams());
        QueryStringValidator queryStringValidator = new QueryStringValidator(action);
        queryStringValidator.validate((MultiMap<String, String>)attributes.getQueryParams());
        QueryParameterValidator queryParamValidator = new QueryParameterValidator(action);
        queryParamValidator.validateAndAddDefaults((MultiMap<String, String>)attributes.getQueryParams(), attributes.getQueryString(), config.isQueryParamsStrictValidation());
        MultiMap<String, String> queryParams = queryParamValidator.getQueryParams();
        String queryString = queryParamValidator.getQueryString();
        HeadersValidator headersValidator = new HeadersValidator();
        headersValidator.validateAndAddDefaults((MultiMap<String, String>)attributes.getHeaders(), action, config.isHeadersStrictValidation());
        MultiMap<String, String> headers = headersValidator.getNewHeaders();
        return AttributesHelper.replaceParams(attributes, headers, queryParams, queryString, (MultiMap<String, String>)new MultiMap(attributes.getUriParams()));
    }
}

