/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.api;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.module.apikit.uri.URICoder;

public class UrlUtils {
    public static final String HTTP_CONTEXT_PATH_PROPERTY = "http.context.path";
    public static final String HTTP_REQUEST_PATH_PROPERTY = "http.request.path";
    private static final String BIND_TO_ALL_INTERFACES = "0.0.0.0";
    public static final String FULL_DOMAIN = "fullDomain";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final Set<Character> ESCAPE_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('/'), Character.valueOf('{'), Character.valueOf('}')));

    private UrlUtils() {
    }

    private static int getEndOfBasePathIndex(String baseAndApiPath, String requestPath) {
        int character;
        int amountOfSlashesInBasePath = 0;
        for (int i = 0; i < baseAndApiPath.length(); ++i) {
            if (Character.compare(baseAndApiPath.charAt(i), '/') != 0) continue;
            ++amountOfSlashesInBasePath;
        }
        int amountOfSlashesInRequestPath = 0;
        for (character = 0; character < requestPath.length() && amountOfSlashesInRequestPath < amountOfSlashesInBasePath; ++character) {
            if (Character.compare(requestPath.charAt(character), '/') != 0) continue;
            ++amountOfSlashesInRequestPath;
        }
        return character;
    }

    public static String encode(String url) {
        return URICoder.encode(url, ESCAPE_CHARS);
    }

    public static String getRelativePath(String baseAndApiPath, String requestPath) {
        int character = UrlUtils.getEndOfBasePathIndex(baseAndApiPath, requestPath);
        String relativePath = requestPath.substring(character);
        if (!"".equals(relativePath)) {
            while (character > 0 && Character.compare(requestPath.charAt(character - 1), '/') == 0) {
                relativePath = "/" + relativePath;
                --character;
            }
        } else {
            relativePath = relativePath + "/";
        }
        return relativePath;
    }

    public static String getListenerPath(String listenerPath, String requestPath) {
        if (!listenerPath.startsWith("/")) {
            listenerPath = "/" + listenerPath;
        }
        if (!requestPath.startsWith("/")) {
            requestPath = "/" + requestPath;
        }
        int slashesAmount = 0;
        for (int i = 0; i < listenerPath.length(); ++i) {
            if (listenerPath.charAt(i) != '/') continue;
            ++slashesAmount;
        }
        String[] split = requestPath.split("/");
        String result = "";
        if (split.length == 0) {
            return "/";
        }
        if (split.length == 1 && split[0].equals("")) {
            return "/";
        }
        for (int i = 0; i < slashesAmount; ++i) {
            if (split[i].equals("")) continue;
            result = result + "/" + split[i];
        }
        return result;
    }

    public static String getBasePath(String baseAndApiPath, String requestPath) {
        int character = UrlUtils.getEndOfBasePathIndex(baseAndApiPath, requestPath);
        return requestPath.substring(0, character);
    }

    public static String replaceBaseUri(String raml, String newBaseUri) {
        if (newBaseUri != null) {
            return UrlUtils.replaceBaseUri(raml, ".*$", newBaseUri);
        }
        return raml;
    }

    private static String replaceBaseUri(String raml, String regex, String replacement) {
        int i;
        Object[] split = raml.split("\n");
        boolean found = false;
        for (i = 0; i < split.length; ++i) {
            if (!split[i].startsWith("baseUri: ")) continue;
            found = true;
            split[i] = ((String)split[i]).replaceFirst(regex, replacement);
            if (((String)split[i]).contains("baseUri: ")) continue;
            split[i] = "baseUri: " + (String)split[i];
        }
        if (!found) {
            for (i = 0; i < split.length; ++i) {
                if (!((String)split[i]).startsWith("title:")) continue;
                split[i] = replacement.contains("baseUri:") ? (String)split[i] + "\n" + replacement : (String)split[i] + "\nbaseUri: " + replacement;
            }
        }
        return StringUtils.join((Object[])split, (String)"\n");
    }

    public static String getCompletePathFromBasePathAndPath(String basePath, String listenerPath) {
        String path = basePath + listenerPath;
        if (path.contains("/*")) {
            path = path.replace("/*", "");
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.contains("//")) {
            path = path.replace("//", "/");
        }
        return path;
    }

    public static String getRedirectLocation(String scheme, String remoteAddress, String requestPath, String queryString) {
        String redirectLocation = scheme + "://" + remoteAddress + requestPath + "/";
        if (StringUtils.isNotEmpty((CharSequence)queryString)) {
            redirectLocation = redirectLocation + "?" + queryString;
        }
        return redirectLocation;
    }

    public static String getBaseUriReplacement(String apiServer) {
        if (apiServer == null) {
            return null;
        }
        String baseUriReplacement = apiServer;
        if (apiServer.contains(BIND_TO_ALL_INTERFACES)) {
            String fullDomain = System.getProperty(FULL_DOMAIN);
            if (fullDomain != null) {
                URL url = null;
                try {
                    url = new URL(apiServer);
                }
                catch (Exception e) {
                    return apiServer;
                }
                String path = url.getPath();
                if (fullDomain.endsWith("/") && path.length() > 0 && path.startsWith("/")) {
                    path = path.length() > 1 ? path.substring(1) : "";
                } else if (!fullDomain.endsWith("/") && path.length() > 0 && !path.startsWith("/")) {
                    fullDomain = fullDomain + "/";
                }
                if (fullDomain.contains("://")) {
                    baseUriReplacement = fullDomain + path;
                } else {
                    String protocol = apiServer.contains(HTTPS) ? HTTPS : HTTP;
                    baseUriReplacement = protocol + fullDomain + path;
                }
            } else {
                baseUriReplacement = baseUriReplacement.replace(BIND_TO_ALL_INTERFACES, "localhost");
            }
        }
        return baseUriReplacement;
    }
}

