/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.Resource;
import org.mule.module.apikit.ApikitErrorTypes;
import org.mule.module.apikit.FlowMapping;
import org.mule.module.apikit.api.FlowUtils;
import org.mule.module.apikit.api.RamlHandler;
import org.mule.module.apikit.api.RoutingTable;
import org.mule.module.apikit.api.uri.URIPattern;
import org.mule.module.apikit.api.uri.URIResolver;
import org.mule.module.apikit.exception.NotImplementedException;
import org.mule.module.apikit.exception.UnsupportedMediaTypeException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.helpers.FlowName;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.core.api.construct.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowFinder {
    protected static final Logger logger = LoggerFactory.getLogger(FlowFinder.class);
    private Map<String, Resource> flatResourceTree = new HashMap<String, Resource>();
    private Map<String, Flow> restFlowMap;
    private Map<String, Flow> restFlowMapUnwrapped;
    protected RoutingTable routingTable;
    private RamlHandler ramlHandler;
    private String configName;
    private List<FlowMapping> flowMappings;
    private ConfigurationComponentLocator locator;
    private ErrorTypeRepository errorTypeRepository;

    public FlowFinder(RamlHandler ramlHandler, String configName, ConfigurationComponentLocator locator, List<FlowMapping> flowMappings) {
        this(ramlHandler, configName, locator, flowMappings, null);
    }

    public FlowFinder(RamlHandler ramlHandler, String configName, ConfigurationComponentLocator locator, List<FlowMapping> flowMappings, ErrorTypeRepository errorTypeRepository) {
        this.ramlHandler = ramlHandler;
        this.configName = configName;
        this.flowMappings = flowMappings;
        this.locator = locator;
        this.errorTypeRepository = errorTypeRepository;
        this.initializeRestFlowMap();
        this.loadRoutingTable();
    }

    protected void initializeRestFlowMap() {
        ApiSpecification api = this.ramlHandler.getApi();
        this.flattenResourceTree(api.getResources(), api.getVersion());
        if (this.restFlowMap == null) {
            this.restFlowMap = new HashMap<String, Flow>();
            List<Flow> flows = this.getFlows();
            for (Flow flow : flows) {
                String key = this.getRestFlowKey(flow.getName());
                if (key == null) continue;
                this.restFlowMap.put(key, flow);
            }
            for (FlowMapping mapping : this.flowMappings) {
                for (Flow flow : flows) {
                    if (!flow.getName().equals(mapping.getFlowRef())) continue;
                    mapping.setFlow(flow);
                    this.restFlowMap.put(mapping.getKey(), mapping.getFlow());
                }
            }
            this.logMissingMappings(api.getVersion());
            this.restFlowMapUnwrapped = new HashMap<String, Flow>(this.restFlowMap);
        }
    }

    private List<Flow> getFlows() {
        return FlowUtils.getFlowsList(this.locator);
    }

    private void flattenResourceTree(Map<String, Resource> resources, String version) {
        for (Resource resource : resources.values()) {
            this.flatResourceTree.put(resource.getResolvedUri(version), resource);
            if (resource.getResources() == null) continue;
            this.flattenResourceTree(resource.getResources(), version);
        }
    }

    public Map<String, Flow> getRawRestFlowMap() {
        return this.restFlowMap;
    }

    private String getRestFlowKey(String name) {
        String[] validMethods = new String[]{"get", "put", "post", "delete", "head", "patch", "options"};
        String[] coords = FlowName.decode(name).split(":");
        if (coords.length < 2) {
            return null;
        }
        String method = coords[0];
        String resource = coords[1];
        if (coords.length > 4 || !Arrays.asList(validMethods).contains(method) || !resource.startsWith("/")) {
            return null;
        }
        if (coords.length == 4) {
            if (coords[3].equals(this.configName)) {
                String contentType = coords[2];
                return this.validateRestFlowKeyAgainstApi(method, resource, contentType);
            }
            return null;
        }
        if (coords.length == 3 && !coords[2].equals(this.configName)) {
            String contentType = coords[2];
            return this.validateRestFlowKeyAgainstApi(method, resource, contentType);
        }
        return this.validateRestFlowKeyAgainstApi(method, resource);
    }

    private String validateRestFlowKeyAgainstApi(String ... coords) {
        Action action;
        Resource apiResource;
        String method = coords[0];
        String resource = coords[1];
        String type = coords.length == 3 ? coords[2] : null;
        String key = String.format("%s:%s", method, resource);
        if (type != null) {
            key = key + ":" + type;
        }
        if ((apiResource = this.flatResourceTree.get(resource)) != null && (action = apiResource.getAction(method)) != null) {
            if (type == null) {
                return key;
            }
            if (!action.hasBody() || action.getBody().entrySet().stream().anyMatch(v -> ((String)v.getKey()).contains(type))) {
                return key;
            }
        }
        logger.warn(String.format("Flow named \"%s\" does not match any RAML descriptor resource", key));
        return null;
    }

    private void logMissingMappings(String version) {
        for (Resource resource : this.flatResourceTree.values()) {
            String fullResource = resource.getResolvedUri(version);
            for (Action action : resource.getActions().values()) {
                String method = action.getType().name().toLowerCase();
                String key = method + ":" + fullResource;
                if (this.restFlowMap.get(key) != null) continue;
                if (action.hasBody()) {
                    for (String contentType : action.getBody().keySet()) {
                        if (this.restFlowMap.get(key + ":" + AttributesHelper.getMediaType(contentType)) != null) continue;
                        logger.warn(String.format("Action-Resource-ContentType triplet has no implementation -> %s:%s:%s ", method, fullResource, AttributesHelper.getMediaType(contentType)));
                    }
                    continue;
                }
                logger.warn(String.format("Action-Resource pair has no implementation -> %s:%s ", method, fullResource));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("==== RestFlows defined:");
            for (String key : this.restFlowMap.keySet()) {
                logger.debug("\t\t" + key);
            }
        }
    }

    private void loadRoutingTable() {
        if (this.routingTable == null) {
            this.routingTable = new RoutingTable(this.ramlHandler.getApi());
        }
    }

    public Flow getFlow(Resource resource, String method, String contentType) throws UnsupportedMediaTypeException {
        String baseKey = method + ":" + resource.getResolvedUri(this.ramlHandler.getApi().getVersion());
        Map<String, Flow> rawRestFlowMap = this.getRawRestFlowMap();
        Flow flow = rawRestFlowMap.get(baseKey + ":" + contentType);
        if (flow == null && (flow = rawRestFlowMap.get(baseKey)) == null) {
            if (this.isFlowDeclaredWithDifferentMediaType(rawRestFlowMap, baseKey)) {
                throw ApikitErrorTypes.throwErrorType(new UnsupportedMediaTypeException(), this.errorTypeRepository);
            }
            throw ApikitErrorTypes.throwErrorType(new NotImplementedException(), this.errorTypeRepository);
        }
        return flow;
    }

    public Resource getResource(URIPattern uriPattern) {
        return this.routingTable.getResource(uriPattern);
    }

    private boolean isFlowDeclaredWithDifferentMediaType(Map<String, Flow> map, String baseKey) {
        for (String flowName : map.keySet()) {
            String[] split = flowName.split(":");
            String methodAndResoruce = split[0] + ":" + split[1];
            if (!methodAndResoruce.equals(baseKey)) continue;
            return true;
        }
        return false;
    }

    public URIPattern findBestMatch(URIResolver resolver) {
        return resolver.find(this.routingTable.keySet(), URIResolver.MatchRule.BEST_MATCH);
    }
}

