/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.mule.apikit.model.Response;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.HeaderName;
import org.mule.module.apikit.api.exception.InvalidHeaderException;
import org.mule.module.apikit.exception.NotAcceptableException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.validation.attributes.MimeTypeParser;
import org.mule.runtime.api.util.MultiMap;

public class HeadersValidator {
    public static MultiMap<String, String> validateAndAddDefaults(Map<String, Parameter> headers, Map<String, Response> responses, MultiMap<String, String> incomingHeaders, boolean headersStrictValidation) throws InvalidHeaderException, NotAcceptableException {
        MultiMap<String, String> headersWithDefaults = HeadersValidator.analyseRequestHeaders(headers, incomingHeaders, headersStrictValidation);
        HeadersValidator.analyseAcceptHeader(responses, headersWithDefaults);
        return headersWithDefaults;
    }

    private static MultiMap<String, String> analyseRequestHeaders(Map<String, Parameter> headers, MultiMap<String, String> incomingHeaders, boolean headersStrictValidation) throws InvalidHeaderException {
        if (headersStrictValidation) {
            HeadersValidator.validateHeadersStrictly(headers, incomingHeaders);
        }
        MultiMap<String, String> copyIncomingHeaders = incomingHeaders;
        for (Map.Entry<String, Parameter> entry : headers.entrySet()) {
            String ramlHeader = entry.getKey();
            Parameter ramlType = entry.getValue();
            if (ramlHeader.contains("{?}")) {
                String regex = ramlHeader.replace("{?}", ".*");
                for (String incomingHeader : copyIncomingHeaders.keySet()) {
                    if (!incomingHeader.matches(regex)) continue;
                    HeadersValidator.validateHeader(copyIncomingHeaders.getAll((Object)incomingHeader), ramlHeader, ramlType);
                }
                continue;
            }
            List<String> values = AttributesHelper.getParamValues(copyIncomingHeaders, ramlHeader);
            if (values.isEmpty() && ramlType.isRequired()) {
                throw new InvalidHeaderException("Required header '" + ramlHeader + "' not specified");
            }
            if (values.isEmpty() && ramlType.getDefaultValue() != null) {
                copyIncomingHeaders = AttributesHelper.copyImmutableMap(copyIncomingHeaders, ramlHeader, ramlType.getDefaultValue());
            }
            HeadersValidator.validateHeader(values, ramlHeader, ramlType);
        }
        return copyIncomingHeaders;
    }

    private static void validateHeadersStrictly(Map<String, Parameter> headers, Map<String, String> incomingHeaders) throws InvalidHeaderException {
        Set standardHeaders;
        Set ramlHeaders = headers.keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
        Set templateHeaders = ramlHeaders.stream().filter(header -> header.contains("{?}")).map(header -> header.replace("{?}", ".*")).collect(Collectors.toSet());
        Set unmatchedHeaders = incomingHeaders.keySet().stream().filter(header -> templateHeaders.stream().noneMatch(header::matches)).collect(Collectors.toSet());
        Sets.SetView undefinedHeaders = Sets.difference(unmatchedHeaders, (Set)Sets.union(ramlHeaders, standardHeaders = Arrays.stream(HeaderName.values()).map(header -> header.getName().toLowerCase()).collect(Collectors.toSet())));
        if (!undefinedHeaders.isEmpty()) {
            throw new InvalidHeaderException(String.format("[%s] %s", Joiner.on((String)", ").join((Iterable)undefinedHeaders), "headers are not defined in RAML and strict headers validation property is true."));
        }
    }

    private static void validateHeader(List<String> values, String name, Parameter type) throws InvalidHeaderException {
        if (values.isEmpty()) {
            return;
        }
        if (values.size() > 1 && !type.isArray() && !type.isRepeat()) {
            throw new InvalidHeaderException("Header " + name + " is not repeatable");
        }
        if (type.isArray()) {
            HeadersValidator.validateTypeArrayValues(name, values, type);
        } else {
            HeadersValidator.validateTypeValue(name, values.get(0), type);
        }
    }

    private static void validateTypeArrayValues(String name, List<String> values, Parameter type) throws InvalidHeaderException {
        String yamlArrayValue = values.stream().collect(Collectors.joining("\n- ", "- ", ""));
        HeadersValidator.validateTypeValue(name, yamlArrayValue, type);
    }

    private static void validateTypeValue(String name, String value, Parameter type) throws InvalidHeaderException {
        if (!type.validate(value)) {
            throw new InvalidHeaderException(String.format("Invalid value '%s' for header '%s'", value, name));
        }
    }

    private static void analyseAcceptHeader(Map<String, Response> responses, MultiMap<String, String> incomingHeaders) throws NotAcceptableException {
        if (MapUtils.isEmpty(responses)) {
            return;
        }
        List<String> mimeTypes = HeadersValidator.getResponseMimeTypes(responses);
        if (CollectionUtils.isEmpty(mimeTypes)) {
            return;
        }
        MediaType bestMatch = MimeTypeParser.bestMatch(mimeTypes, AttributesHelper.getAcceptedResponseMediaTypes(incomingHeaders));
        if (bestMatch == null) {
            throw new NotAcceptableException();
        }
    }

    private static List<String> getResponseMimeTypes(Map<String, Response> responses) {
        String status = AttributesHelper.getSuccessStatus(responses);
        Response response = responses.get(status);
        if (response != null && response.hasBody()) {
            return new ArrayList<String>(response.getBody().keySet());
        }
        return new ArrayList<String>();
    }
}

