/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.util.HashMap;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.Resource;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpRequestAttributesBuilder;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.api.exception.MethodNotAllowedException;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.api.uri.ResolvedVariables;
import org.mule.module.apikit.api.validation.ValidBody;
import org.mule.module.apikit.api.validation.ValidRequest;
import org.mule.module.apikit.validation.AttributesValidator;
import org.mule.module.apikit.validation.BodyValidator;
import org.mule.module.apikit.validation.HttpMethodValidator;
import org.mule.runtime.api.exception.ErrorTypeRepository;

public class RestRequestValidator {
    private final ValidationConfig config;
    private final Resource resource;
    private final ErrorTypeRepository errorTypeRepository;
    private static final HttpMethodValidator methodValidator = new HttpMethodValidator();

    public RestRequestValidator(ValidationConfig config, Resource resource, ErrorTypeRepository errorTypeRepository) {
        this.config = config;
        this.resource = resource;
        this.errorTypeRepository = errorTypeRepository;
    }

    public ValidRequest validate(ResolvedVariables uriParams, HttpRequestAttributes attributes, String payloadCharset, Object body) throws MuleRestException {
        String method = attributes.getMethod().toLowerCase();
        methodValidator.validateHttpMethod(method);
        Action action = this.resource.getAction(method);
        if (action == null) {
            throw new MethodNotAllowedException(String.format("HTTP Method %s not allowed for : %s", method, this.resource.getUri()));
        }
        if (this.config.isDisableValidations()) {
            return ValidRequest.builder().withAttributes(this.addUriParams(uriParams, attributes)).withBody(new ValidBody(body)).build();
        }
        HttpRequestAttributes validAttributes = AttributesValidator.validateAndAddDefaults(attributes, action, uriParams, this.config);
        ValidBody validBody = BodyValidator.validate(action, attributes, body, this.config, payloadCharset, this.errorTypeRepository);
        return ValidRequest.builder().withAttributes(validAttributes).withBody(validBody).build();
    }

    private HttpRequestAttributes addUriParams(ResolvedVariables uriParams, HttpRequestAttributes attributes) {
        HashMap uriParamsMap = new HashMap();
        uriParams.names().stream().forEach(name -> uriParamsMap.put(name, String.valueOf(uriParams.get((String)name))));
        return new HttpRequestAttributesBuilder(attributes).uriParams(uriParamsMap).build();
    }
}

