/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.schema.v2;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.validation.ApiValidationResult;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.validation.body.schema.IRestSchemaValidatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSchemaV2Validator
implements IRestSchemaValidatorStrategy {
    protected static final Logger logger = LoggerFactory.getLogger(RestSchemaV2Validator.class);
    private MimeType mimeType;

    public RestSchemaV2Validator(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public void validate(String payload) throws BadRequestException {
        List validationResults = this.mimeType.validate(payload);
        if (!validationResults.isEmpty()) {
            throw new BadRequestException(this.buildLogMessage(validationResults));
        }
    }

    private String buildLogMessage(List<ApiValidationResult> validationResults) {
        return validationResults.stream().map(result -> result.getMessage().replace("\n", "")).collect(Collectors.joining("\n"));
    }
}

