/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.module.apikit.StreamUtils;
import org.mule.module.apikit.api.exception.InvalidFormParameterException;
import org.mule.module.apikit.validation.body.form.FormValidator;
import org.mule.module.apikit.validation.body.form.transformation.MultipartFormData;
import org.mule.module.apikit.validation.body.form.transformation.MultipartFormDataBuilder;
import org.mule.module.apikit.validation.body.form.transformation.MultipartFormDataParameter;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public class MultipartFormValidator
implements FormValidator<TypedValue> {
    private final Map<String, List<Parameter>> formParameters;

    public MultipartFormValidator(Map<String, List<Parameter>> formParameters) {
        this.formParameters = formParameters;
    }

    @Override
    public TypedValue validate(TypedValue originalPayload) throws InvalidFormParameterException {
        InputStream inputStream = StreamUtils.unwrapCursorStream(originalPayload.getValue());
        String boundary = this.getBoundary(originalPayload);
        MultipartFormDataBuilder multipartFormDataBuilder = new MultipartFormDataBuilder(inputStream, boundary);
        Map<String, MultipartFormDataParameter> actualParameters = multipartFormDataBuilder.getFormDataParameters();
        boolean hasDefaultValues = false;
        for (String expectedKey : this.formParameters.keySet()) {
            List<Parameter> params = this.formParameters.get(expectedKey);
            if (params == null || params.size() != 1) continue;
            Parameter expected = params.get(0);
            if (actualParameters.containsKey(expectedKey)) {
                MultipartFormDataParameter multipartFormDataParameter = actualParameters.get(expectedKey);
                multipartFormDataParameter.validate(expected);
                continue;
            }
            if (expected.getDefaultValue() != null) {
                multipartFormDataBuilder.addDefault(expectedKey, expected.getDefaultValue());
                hasDefaultValues = true;
                continue;
            }
            if (!expected.isRequired()) continue;
            throw new InvalidFormParameterException("Required form parameter " + expectedKey + " not specified");
        }
        if (!hasDefaultValues && !(originalPayload.getValue() instanceof InputStream)) {
            return originalPayload;
        }
        return this.getTypedValue(multipartFormDataBuilder.build());
    }

    private TypedValue getTypedValue(MultipartFormData multipartFormData) throws InvalidFormParameterException {
        InputStream is = multipartFormData.getInputStream();
        MediaType mediaType = MediaType.parse((String)multipartFormData.getContentType());
        DataType dataType = DataType.builder((DataType)DataType.INPUT_STREAM).mediaType(mediaType).build();
        return new TypedValue((Object)is, dataType, OptionalLong.of(multipartFormData.getLength()));
    }

    private String getBoundary(TypedValue originalPayload) throws InvalidFormParameterException {
        String boundary = originalPayload.getDataType().getMediaType().getParameter("boundary");
        if (boundary == null) {
            throw new InvalidFormParameterException("Required boundary parameter not found");
        }
        return boundary;
    }
}

