/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.apikit.model.Action;
import org.mule.module.apikit.validation.attributes.HeadersValidator;
import org.mule.module.apikit.validation.attributes.QueryParameterValidator;
import org.mule.module.apikit.validation.attributes.QueryStringValidator;

public enum ValidatorsCache {
    INSTANCE;

    private Map<Action, QueryParameterValidator> queryParamValidators = new ConcurrentHashMap<Action, QueryParameterValidator>();
    private Map<Action, QueryStringValidator> queryStringValidators = new ConcurrentHashMap<Action, QueryStringValidator>();
    private Map<Action, HeadersValidator> headersValidators = new ConcurrentHashMap<Action, HeadersValidator>();

    public QueryParameterValidator getQueryParameterValidator(Action action) {
        return this.queryParamValidators.computeIfAbsent(action, key -> new QueryParameterValidator((Action)key));
    }

    public QueryStringValidator getQueryStringValidator(Action action) {
        return this.queryStringValidators.computeIfAbsent(action, key -> new QueryStringValidator((Action)key));
    }

    public HeadersValidator getHeadersValidator(Action action) {
        return this.headersValidators.computeIfAbsent(action, key -> new HeadersValidator((Action)key));
    }
}

