/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.uri;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.mule.module.apikit.api.exception.ApikitRuntimeException;

public class URICoder {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int ENCODE_INITIAL_CAPACITY = 16;
    private static final Set<Character> skipChars = new HashSet<Character>(Arrays.asList(Character.valueOf('/'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('%'), Character.valueOf(':')));
    private static final Set<Character> escapeChars = new HashSet<Character>(Arrays.asList(Character.valueOf('/'), Character.valueOf('{'), Character.valueOf('}')));

    private URICoder() {
    }

    public static String encodeRequestPath(String rawRequestPath) throws ApikitRuntimeException {
        boolean encoded;
        boolean bl = encoded = !rawRequestPath.equals(URICoder.decode(rawRequestPath));
        if (encoded && URICoder.containsSpecialChars(rawRequestPath, skipChars)) {
            throw new ApikitRuntimeException("Request path contains special characters not encoded");
        }
        return encoded ? rawRequestPath : URICoder.encode(rawRequestPath, escapeChars);
    }

    public static String encode(String s, Set<Character> chars) {
        if (s.length() == 0) {
            return s;
        }
        boolean ascii = URICoder.isASCII(s);
        return ascii ? URICoder.encode_ASCII(s, chars) : URICoder.encode_UTF8(s, chars);
    }

    private static boolean containsSpecialChars(String path, Set<Character> skipChars) {
        if (path == null || path.length() == 0) {
            return false;
        }
        for (int index = 0; index < path.length(); ++index) {
            char character = path.charAt(index);
            if (skipChars.contains(Character.valueOf(character)) || URICoder.isUnreserved(character)) continue;
            return true;
        }
        return false;
    }

    private static String encode_ASCII(String s, Set<Character> chars) {
        StringBuilder sb = new StringBuilder(s.length() + 16);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (URICoder.isUnreserved(c) || chars.contains(Character.valueOf(c))) {
                sb.append(c);
                continue;
            }
            URICoder.appendEscape(sb, c);
        }
        return sb.toString();
    }

    private static String encode_UTF8(String s, Set<Character> chars) {
        String n = Normalizer.isNormalized(s, Normalizer.Form.NFKC) ? s : Normalizer.normalize(s, Normalizer.Form.NFKC);
        ByteBuffer bb = UTF8.encode(n);
        StringBuffer sb = new StringBuffer();
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (URICoder.isUnreserved(b) || chars.contains(Character.valueOf((char)b))) {
                sb.append((char)b);
                continue;
            }
            URICoder.appendEscape(sb, (byte)b);
        }
        return sb.toString();
    }

    public static String decode(String s) {
        if (s.length() == 0 || s.indexOf(37) < 0 && s.indexOf(43) < 0) {
            return s;
        }
        boolean ascii = URICoder.isEncodedASCII(s);
        return ascii ? URICoder.decode_ASCII(s) : URICoder.decode_UTF8(s);
    }

    private static String decode_ASCII(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                if (i >= s.length() - 2) continue;
                String hex = String.copyValueOf(new char[]{s.charAt(++i), s.charAt(++i)});
                char x = (char)Integer.parseInt(hex, 16);
                sb.append(x);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String decode_UTF8(String s) {
        ByteBuffer bb = ByteBuffer.allocate(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                if (i >= s.length() - 2) continue;
                String hex = "" + s.charAt(++i) + s.charAt(++i);
                byte b = (byte)Integer.parseInt(hex, 16);
                bb.put(b);
                continue;
            }
            bb.put((byte)c);
        }
        bb.limit(bb.position());
        bb.position(0);
        return UTF8.decode(bb).toString();
    }

    private static void appendEscape(StringBuffer sb, byte b) {
        sb.append('%');
        sb.append(HEX_DIGITS[b >> 4 & 0xF]);
        sb.append(HEX_DIGITS[b >> 0 & 0xF]);
    }

    private static void appendEscape(StringBuilder sb, char c) {
        sb.append('%');
        sb.append(HEX_DIGITS[c >> 4 & 0xF]);
        sb.append(HEX_DIGITS[c >> 0 & 0xF]);
    }

    private static boolean isUnreserved(int c) {
        if (c >= 97 && c <= 122) {
            return true;
        }
        if (c >= 65 && c <= 90) {
            return true;
        }
        if (c >= 48 && c <= 57) {
            return true;
        }
        return c == 46 || c == 95 || c == 45 || c == 126;
    }

    private static boolean isASCII(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    private static boolean isEncodedASCII(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '%' || i >= s.length() - 1 || s.charAt(i + 1) <= '7') continue;
            return false;
        }
        return true;
    }
}

