/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.form.transformation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

class LimitedByteArrayOutputStream
extends ByteArrayOutputStream {
    private final long maxBytes;
    private long bytesWritten;

    LimitedByteArrayOutputStream(long maxBytes) {
        this.maxBytes = maxBytes;
    }

    @Override
    public void write(int b) {
        try {
            this.ensureCapacity(1);
        }
        catch (IOException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
        super.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.ensureCapacity(b.length);
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        try {
            this.ensureCapacity(len);
        }
        catch (IOException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
        super.write(b, off, len);
    }

    private void ensureCapacity(int len) throws IOException {
        long newBytesWritten = this.bytesWritten + (long)len;
        if (newBytesWritten > this.maxBytes) {
            throw new IOException("Multipart content exceeded the maximum size supported");
        }
        this.bytesWritten = newBytesWritten;
    }
}

