/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.github.fge.jsonschema.main.JsonSchema;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.xml.validation.Schema;
import org.apache.commons.lang3.StringUtils;
import org.mule.apikit.ApiType;
import org.mule.module.apikit.ApikitErrorTypes;
import org.mule.module.apikit.ApikitParserMode;
import org.mule.module.apikit.ApikitRegistry;
import org.mule.module.apikit.FlowFinder;
import org.mule.module.apikit.FlowMapping;
import org.mule.module.apikit.api.RamlHandler;
import org.mule.module.apikit.api.config.ConsoleConfig;
import org.mule.module.apikit.api.config.ValidationConfig;
import org.mule.module.apikit.api.deserializing.AttributesDeserializingStrategies;
import org.mule.module.apikit.api.exception.ApikitRuntimeException;
import org.mule.module.apikit.api.spi.RouterService;
import org.mule.module.apikit.api.spi.RouterServiceV2;
import org.mule.module.apikit.api.uri.URIPattern;
import org.mule.module.apikit.api.uri.URIResolver;
import org.mule.module.apikit.api.validation.ApiKitJsonSchema;
import org.mule.module.apikit.validation.body.schema.v1.cache.JsonSchemaCacheLoader;
import org.mule.module.apikit.validation.body.schema.v1.cache.XmlSchemaCacheLoader;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
implements Disposable,
Initialisable,
ValidationConfig,
ConsoleConfig {
    private static final String DEFAULT_OUTBOUND_HEADERS_MAP_NAME = "outboundHeaders";
    private static final String DEFAULT_HTTP_STATUS_VAR_NAME = "httpStatus";
    private static final int URI_CACHE_SIZE = 1000;
    public static final String MULE_EXTERNAL_ENTITIES_PROPERTY = "mule.xml.expandExternalEntities";
    public static final String MULE_EXPAND_ENTITIES_PROPERTY = "mule.xml.expandInternalEntities";
    protected static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    protected LoadingCache<String, URIResolver> uriResolverCache;
    protected LoadingCache<String, URIPattern> uriPatternCache;
    private boolean disableValidations;
    private ApikitParserMode parserMode;
    private boolean queryParamsStrictValidation;
    private boolean headersStrictValidation;
    private String name;
    private String raml;
    private String api;
    private boolean keepApiBaseUri;
    private boolean keepRamlBaseUri;
    private String outboundHeadersMapName;
    private String httpStatusVarName;
    private List<FlowMapping> flowMappings = new ArrayList<FlowMapping>();
    private AttributesDeserializingStrategies attributesDeserializingStrategies = new AttributesDeserializingStrategies();
    private LoadingCache<String, JsonSchema> jsonSchemaCache;
    private LoadingCache<String, Schema> xmlSchemaCache;
    private RamlHandler ramlHandler;
    private FlowFinder flowFinder;
    private RouterService routerService;
    private RouterServiceV2 routerServiceV2;
    private boolean extensionEnabled;
    @Inject
    private MuleContext muleContext;
    @Inject
    private ApikitRegistry registry;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private ConfigurationComponentLocator locator;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;

    public void initialise() throws InitialisationException {
        this.xmlEntitiesConfiguration();
        this.routerServiceV2 = this.findExtensionV2();
        this.routerService = this.routerServiceV2 == null ? this.findExtension() : null;
        this.scheduler = this.getScheduler();
        try {
            this.ramlHandler = new RamlHandler((ScheduledExecutorService)this.scheduler, this.getApi(), this.isKeepApiBaseUri(), ApikitErrorTypes.errorRepositoryFrom(this.muleContext), this.parserMode.get());
            this.initRouterService();
        }
        catch (Exception e) {
            throw new InitialisationException(e.fillInStackTrace(), (Initialisable)this);
        }
        this.flowFinder = new FlowFinder(this.ramlHandler, this.getName(), this.locator, this.flowMappings, ApikitErrorTypes.errorRepositoryFrom(this.muleContext));
        this.buildResourcePatternCaches();
        this.registry.registerConfiguration(this);
    }

    private void initRouterService() {
        try {
            if (this.routerServiceV2 != null) {
                this.routerServiceV2.initialise(this.ramlHandler.getApi().getUri(), this.getScheduler());
                return;
            }
            if (this.routerService != null) {
                this.routerService.initialise(this.ramlHandler.getApi().getUri());
            }
        }
        catch (MuleException e) {
            throw new ApikitRuntimeException("Couldn't load enabled extension", e);
        }
    }

    @Deprecated
    public String getApiServer() {
        return "http://localhost:8081";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRaml() {
        return this.raml;
    }

    public void setRaml(String raml) {
        this.raml = raml;
    }

    public String getApi() {
        return StringUtils.isEmpty((CharSequence)this.api) ? this.raml : this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    @Override
    public boolean isDisableValidations() {
        return this.disableValidations;
    }

    public void setDisableValidations(boolean disableValidations) {
        this.disableValidations = disableValidations;
    }

    public void setParser(ApikitParserMode parserType) {
        this.parserMode = parserType;
    }

    @Override
    public boolean isQueryParamsStrictValidation() {
        return this.queryParamsStrictValidation;
    }

    public void setQueryParamsStrictValidation(boolean queryParamsStrictValidation) {
        this.queryParamsStrictValidation = queryParamsStrictValidation;
    }

    @Override
    public boolean isHeadersStrictValidation() {
        return this.headersStrictValidation;
    }

    public void setHeadersStrictValidation(boolean headersStrictValidation) {
        this.headersStrictValidation = headersStrictValidation;
    }

    @Deprecated
    public boolean isKeepRamlBaseUri() {
        return this.keepRamlBaseUri;
    }

    public boolean isKeepApiBaseUri() {
        return this.keepApiBaseUri || this.isKeepRamlBaseUri();
    }

    @Deprecated
    public void setKeepRamlBaseUri(boolean keepRamlBaseUri) {
        this.keepRamlBaseUri = keepRamlBaseUri;
    }

    public void setKeepApiBaseUri(boolean keepApiBaseUri) {
        this.keepApiBaseUri = keepApiBaseUri;
    }

    public List<FlowMapping> getFlowMappings() {
        return this.flowMappings;
    }

    public void setFlowMappings(List<FlowMapping> flowMappings) {
        this.flowMappings = flowMappings;
    }

    public String getOutboundHeadersMapName() {
        if (this.outboundHeadersMapName == null) {
            return DEFAULT_OUTBOUND_HEADERS_MAP_NAME;
        }
        return this.outboundHeadersMapName;
    }

    public void setOutboundHeadersMapName(String outboundHeadersMapName) {
        this.outboundHeadersMapName = outboundHeadersMapName;
    }

    public String getHttpStatusVarName() {
        if (this.httpStatusVarName == null) {
            return DEFAULT_HTTP_STATUS_VAR_NAME;
        }
        return this.httpStatusVarName;
    }

    public void setHttpStatusVarName(String httpStatusVarName) {
        this.httpStatusVarName = httpStatusVarName;
    }

    private void buildResourcePatternCaches() {
        logger.info("Building resource URI cache...");
        this.uriResolverCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, URIResolver>(){

            public URIResolver load(String path) throws IOException {
                return new URIResolver(path);
            }
        });
        this.uriPatternCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, URIPattern>(){

            public URIPattern load(String path) throws Exception {
                URIResolver resolver = (URIResolver)Configuration.this.uriResolverCache.get((Object)path);
                URIPattern match = Configuration.this.flowFinder.findBestMatch(resolver);
                if (match == null) {
                    logger.warn("No matching patterns for URI " + path);
                    throw new IllegalStateException("No matching patterns for URI " + path);
                }
                return match;
            }
        });
    }

    public FlowFinder getFlowFinder() {
        return this.flowFinder;
    }

    public LoadingCache<String, URIPattern> getUriPatternCache() {
        return this.uriPatternCache;
    }

    public LoadingCache<String, URIResolver> getUriResolverCache() {
        return this.uriResolverCache;
    }

    public LoadingCache<String, JsonSchema> getJsonSchemaCache() {
        if (this.jsonSchemaCache == null) {
            this.jsonSchemaCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new JsonSchemaCacheLoader(this.ramlHandler.getApi()));
        }
        return this.jsonSchemaCache;
    }

    public LoadingCache<String, Schema> getXmlSchemaCache() {
        if (this.xmlSchemaCache == null) {
            LoadingCache transformerCache;
            this.xmlSchemaCache = transformerCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new XmlSchemaCacheLoader(this.ramlHandler.getApi()));
        }
        return this.xmlSchemaCache;
    }

    public void setRamlHandler(RamlHandler ramlHandler) {
        this.ramlHandler = ramlHandler;
    }

    @Override
    public RamlHandler getRamlHandler() {
        return this.ramlHandler;
    }

    @Override
    public ApiType getType() {
        return this.ramlHandler != null ? this.ramlHandler.getApi().getType() : ApiType.AMF;
    }

    @Override
    public boolean isParserV2() {
        return this.getRamlHandler().isParserV2();
    }

    @Override
    public ApiKitJsonSchema getJsonSchema(String schemaPath) throws ExecutionException {
        try {
            return new ApiKitJsonSchema((JsonSchema)this.getJsonSchemaCache().get((Object)schemaPath));
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return null;
        }
    }

    @Override
    public Schema getXmlSchema(String schemaPath) throws ExecutionException {
        return (Schema)this.getXmlSchemaCache().get((Object)schemaPath);
    }

    @Override
    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    private RouterService findExtension() {
        return this.findExtension(RouterService.class);
    }

    private RouterServiceV2 findExtensionV2() {
        return this.findExtension(RouterServiceV2.class);
    }

    private <T> T findExtension(Class<T> clazz) {
        ClassLoader executionClassLoader = this.muleContext.getExecutionClassLoader();
        ServiceLoader<T> routerServices = ServiceLoader.load(clazz, executionClassLoader);
        Iterator<T> iterator = routerServices.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public Optional<RouterService> getExtension() {
        return Optional.ofNullable(this.routerService);
    }

    public Optional<RouterServiceV2> getExtensionV2() {
        return Optional.ofNullable(this.routerServiceV2);
    }

    private void xmlEntitiesConfiguration() {
        System.setProperty("amf.plugins.xml.validateUnion", "true");
        String externalEntities = System.getProperty(MULE_EXTERNAL_ENTITIES_PROPERTY, "false");
        System.setProperty("raml.xml.expandExternalEntities", externalEntities);
        System.setProperty("amf.plugins.xml.expandExternalEntities", externalEntities);
        String internalEntities = System.getProperty(MULE_EXPAND_ENTITIES_PROPERTY, "false");
        System.setProperty("raml.xml.expandInternalEntities", internalEntities);
        System.setProperty("amf.plugins.xml.expandInternalEntities", internalEntities);
    }

    private Scheduler getScheduler() {
        SchedulerConfig config = SchedulerConfig.config().withMaxConcurrentTasks(Runtime.getRuntime().availableProcessors()).withName("AMF-SCHEDULER");
        return this.schedulerService.customScheduler(config, Integer.MAX_VALUE);
    }

    public void dispose() {
        this.scheduler.shutdownNow();
    }

    @Override
    public AttributesDeserializingStrategies getAttributesDeserializingStrategies() {
        return this.attributesDeserializingStrategies;
    }

    public void setAttributesDeserializingStrategies(AttributesDeserializingStrategies attributesDeserializingStrategies) {
        this.attributesDeserializingStrategies = attributesDeserializingStrategies;
    }
}

